//systemVerilog HDL for "violin", "out_cml" "systemVerilog"

`include "xmodel.h"

module out_cml (
    input vddt,
    input vss,
    input [3:0] cmlbias_ctrlb,
    input bias_rstb,
    input cml_enb,
    `input_xbit inp,
    `input_xbit inn,
    `output_xbit outp,
    `output_xbit outn
);

    xbit cml_en;

    bit_to_xbit conn(.in(~cml_enb), .out(cml_en));

    and2_xbit and0(.in_a(cml_en), .in_b(inp), .out(outp));
    and2_xbit and1(.in_a(cml_en), .in_b(inn), .out(outn));

endmodule
