/*----------------------------------------------------------------------
MODEL top.sv

= Purpose =

dpll model

= Description =

= Revisions =

$Authors$
$DateTime$
$Id$

----------------------------------------------------------------------*/

module top(
    input vdda,
    input vddt,
    input vss,

    `input_xbit clk_ref_p,
    `input_xbit clk_ref_n,

    input reset_n,

    output clk_fb,
    output clk_ref_out,
    `output_xbit clk_outp,
    `output_xbit clk_outn
);

    wire w_reset_n;  

    `xbit(x_clk_ref);
    wire w_clk_ref;  

    `xbit(x_clk_fb);
    wire w_clk_fb;   

    `xbit(x_clk_outp); 
    `xbit(x_clk_outn); 

    `ifndef SYN
        xbit_to_bit xb2b0( .in(x_clk_ref), .out(w_clk_ref));
        xbit_to_bit xb2b1( .in(x_clk_fb), .out(w_clk_fb));
    `else
        assign w_clk_ref = x_clk_ref;
        assign w_clk_fb = x_clk_fb;
    `endif

    //PAD Define
    //corner cell
    pad_corner cornerul(.vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    pad_corner cornerur(.vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    pad_corner cornerlr(.vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    pad_corner cornerll(.vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));

    //Counter clock wise dierection from left to top point
    // 1. left side ( # inc. down to up) 
    padv_in_cmos     G1_8( .pad(reset_n), .core_in(w_reset_n), .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padv_vss         G1_7(.vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padv_vdda_1      G1_6( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padv_vss         G1_5( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padv_vdda_0      G1_4( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padv_vss         G1_3( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padv_out_cmos_en G1_2( .pad(clk_ref_out), .core_out(w_clk_ref), .out_en(1'b1), .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padv_vss         G1_1( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));

    // 2. top side ( #inc. left to right)
    padh_vss         G2_1( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vddt        G2_2( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vss         G2_3( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vdda_0      G2_4( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vss         G2_5( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vdda_1      G2_6( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vss         G2_7( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vddt        G2_8( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));

    // 3. right side ( #inc. down to up)
    padh_vss         G3_8( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vddt        G3_7( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vss         G3_6( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vdda_0      G3_5( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vss         G3_4( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vddt        G3_3( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vss         G3_2( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vdda_1      G3_1( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));

    // 4. bottom side ( #inc. left to right)
    padh_empty       G4_1( .pad(clk_ref_n), .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_empty       G4_2( .pad(clk_ref_p), .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vss         G4_3( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_out_cmos_en G4_4( .pad(clk_fb), .core_out(w_clk_fb), .out_en(1'b1), .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vss         G4_5( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_empty       G4_6( .pad(clk_outn), .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_empty       G4_7( .pad(clk_outp), .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));
    padh_vss         G4_8( .vdda_0(vdda), .vdda_1(), .vddt(vddt), .vss(vss));

    //custom cell
    in_csda in_csda(
        .vddt(vddt),
        .vss(vss),
        .inp(clk_ref_p),
        .inn(clk_ref_n),
        .out(x_clk_ref)
    );

    out_cml out_cml(
        .vddt(vddt),
        .vss(vss),
        .cmlbias_ctrlb(4'b0000),
        .bias_rstb(w_reset_n),
        .cml_enb(1'b0),
        .inp(x_clk_outp),
        .inn(x_clk_outn),
        .outp(clk_outp),
        .outn(clk_outn)
    );

    dpll dpll0 (
        .clk_ref(x_clk_ref),    
        .reset_n(w_reset_n),        
        .vdda(vdda),       
        .vddt(vddt),     
        .vss(vss),       
        .tdc_f_range(2'b10),
        .ph_rot_f_range(2'b01),
        .pgain_ctrl(3'b111),        
        .div_sel_prescaler(2'b10),  
        .phsel(7'b000_0000),        
        .clk_fb(x_clk_fb),          
        .clk_outp(x_clk_outp),      
        .clk_outn(x_clk_outn)       
    );

endmodule
