/*----------------------------------------------------------------------
TESTBENCH tb_locking.sv

= Purpose =

A testbench to observe frequency locking transient behavior of a digital PLL.

= Description =

A clock generator(clk_gen) feeds a fixed frequency clock to the dpll. The recovered clock is observed to check its locking ability.

= Revisions =

$Author$
$DateTIme$
----------------------------------------------------------------------*/

`include "xmodel.h"

module tb_locking();	

    parameter real ref_freq = 125.0e6;  // reference frequency
    parameter real RJ_rms = 1.0e-12;    // reference clock RMS random jitter

    // variables
    reg reset_n;        // reset (active low)

    wire clk_fb, clk_ref_out;

    xbit clk_ref_p, clk_ref_n;
    xbit clk_outp, clk_outn;

    reg vdda = 1;
    reg vddt = 1;
    reg vss = 0;

    // reference clock generator 
    clk_gen     #(.freq(ref_freq), .RJ_rms(RJ_rms), .init_phase(0)) clk_gen_p(clk_ref_p);
    clk_gen     #(.freq(ref_freq), .RJ_rms(RJ_rms), .init_phase(M_PI/2)) clk_gen_n(clk_ref_n);

    initial begin
        reset_n = 1'b0;
        #(1e-9/`TIME_SCALE) reset_n = 1'b0;
        #(2e-9/`TIME_SCALE) reset_n = 1'b1;
    end

    // DUT (device-under-test) digital PLL
    top
            DUT(.clk_ref_p(clk_ref_p), .clk_ref_n(clk_ref_n),
                .reset_n(reset_n),
                .vdda(vdda), .vddt(vddt), .vss(vss),
                .clk_fb(clk_fb), .clk_ref_out(clk_ref_out),
                .clk_outp(clk_outp), .clk_outn(clk_outn));

    // probing
    probe_bit   probe_ref(clk_ref_out);
    probe_bit   probe_fb(clk_fb);
    probe_xbit  probe_outp(clk_outp);
    probe_xbit  probe_outn(clk_outn);
    probe_freq  probe_freq(clk_outp);
    probe_phase #(.freq(ref_freq*64), .phase_wrap(0)) probe_phase(clk_outp);

    initial begin
    `ifdef SDF
        $sdf_annotate("/afs/mics.snu.ac.kr/user/eunseo/IDEC_CBDF/xmodel_dpll/top/top.output.sdf",DUT);
        $vcdplusfile ("tb_locking.sdf.vpd");
    `else
        $vcdplusfile("tb_locking.vpd");
    `endif
        $vcdpluson;
    end

endmodule
