#!/usr/bin/env xmodelpy

from __future__ import absolute_import
from __future__ import print_function
import sys
import os
import re
from optparse import OptionParser
from numpy import log

CBD_ROOT = os.environ["CBD_ROOT"]
sys.path.append(CBD_ROOT+"/lib/python")

import pyverilog.utils.version
from pyverilog.vparser.parser import VerilogCodeParser
from pyverilog.ast_code_generator.codegen import ASTCodeGenerator
import pyverilog.vparser.ast as vast

type_xbit = type(vast.Xbit(0))
type_xreal = type(vast.Xreal(0))
type_xbitarray = type(vast.XbitArray(0,0,0))
type_xrealarray = type(vast.XrealArray(0,0,0))
type_decl = type(vast.Decl(0))
type_supply = type(vast.Supply(0,0))
type_input = type(vast.Input(0))
type_output = type(vast.Output(0))
type_inout = type(vast.Inout(0))
type_wire = type(vast.Wire(0))
type_instancelist = type(vast.InstanceList(0,0,0))
type_concat = type(vast.Concat(0,0))

main_dir = os.getcwd()

def xmodel_parse(filename):

    f = open("header.h",'r')
    g = open(filename,'r')
    h = open("header_"+filename,'w')

    h.write(f.read())
    h.write(g.read())
    h.close()
    
    filename = "header_"+filename
    
    codeparser = VerilogCodeParser([filename])

    ast = codeparser.parse()
    directives = codeparser.get_directives()

    os.remove(filename)

    return ast,directives

def get_decllist(items):

    decllist = []

    for i in range(0,len(items)):
        if(type(items[i]) == type_decl):
            decllist.append(items[i]) 

    return decllist

def split_into_decl(items):
    decllist = []
    remains = []

    for i in range(0,len(items)):
        if(type(items[i]) == type_decl):
            decllist.append(items[i]) 
        else :
            remains.append(items[i])

    return decllist,remains

def get_var_data(variable):

    lineno = variable.lineno
    name = variable.name
    width = variable.width
    signed = variable.signed
    type_var = type(variable)

    return lineno,name,width,signed,type_var

def get_ioport_data(ioport):

    port_direction = ioport.first
    port_type = ioport.second

    return port_direction,port_type

def get_module_namelist(ast):
    
    modulelist = list(ast.description.definitions)

    namelist = []
    
    for module in modulelist :
        name = module.name
        namelist.append(name)

    return namelist

def get_module_data(ast,name):

    modulelist = list(ast.description.definitions)
    
    index = -1
    for i in range(0,len(modulelist)) :
        if ( modulelist[i].name == name ) :
            index = i
            break
    if index == -1 :
        #print("can't find the instance in the modelfile")
        return -1,-1,-1,-1,-1

    name = modulelist[index].name
    paramlist = modulelist[index].paramlist
    portlist = modulelist[index].portlist
    items = modulelist[index].items

    del modulelist[index]

    return name,paramlist,portlist,items,modulelist

def get_port_data(port):
    
    lineno = port.lineno
    name = port.name
    width = port.width
    port_type = port.type

    return lineno,name,width,port_type

def get_port_lineno(portlist,name):

    ports = portlist.ports
    lineno = -1
    for i in range(0,len(ports)):
        lineno,port_name,width,port_type = get_port_data(ports[i])
        if(name == port_name):
            return lineno
    
    if(lineno == -1):
        print("error from get_port_lineno. there is no port name "+name)
        sys.exit()
        
def remove_port(portlist,name):

    for i in range(0,len(portlist.ports)):
        lineno,port_name,width,port_type = get_port_data(portlist.ports[i])
        if(name == port_name):
            del portlist.ports[i]
            break

def port_decl_modify(portlist_model,decllist_model,portlist_pnr,decllist_pnr):

    xbit_decl_namelist = []
    xreal_decl_namelist = []

    for i in range(0,len(decllist_model)):
        for j in range(0,len(decllist_model[i].list)):

            var = decllist_model[i].list[j]

            lineno,name,width,signed,type_var = get_var_data(var)

            if(type(var) == type_xbit):
                xbit_decl_namelist.append(name)
            elif(type(var) == type_xreal):
                xreal_decl_namelist.append(name)
            else : continue

    xbit_port_namelist = []
    xreal_port_namelist = []

    ports_model = portlist_model.ports

    for i in range(0,len(ports_model)):
        port = ports_model[i]
        port_dir,port_type = get_ioport_data(port)

        lineno,name,width,signed,type_port = get_var_data(port_dir)

        if(type(port_type) == type_xbit):
            xbit_port_namelist.append(name)
        elif(type(port_type) == type_xreal):
            xreal_port_namelist.append(name)
        else : continue

    portlist_modified = vast.Portlist(list(portlist_pnr.ports),portlist_pnr.lineno) 
    decllist_modified = []

#    print(decllist_pnr)
#    print(portlist_pnr)

    #print(portlist_model.ports)
    #print(portlist_pnr.ports)
    
    #print(portlist_pnr.lineno)

    new_ioport_list = []

    for i in range(0,len(decllist_pnr)):

        new_decl = vast.Decl([],lineno=decllist_pnr[i].lineno)

       # new_port = vast.Ioport(port_dir)

        for j in range(0,len(decllist_pnr[i].list)):

#            print(decllist_pnr[i])
#            print(decllist_pnr[i].list)
            var = decllist_pnr[i].list[j]
            lineno,name,width,signed,type_var = get_var_data(var)
#            print(name)

            if(width!=None):
                new_width = vast.Width(msb=width.msb,lsb=width.lsb,lineno=width.lineno)
            else:
                new_width = None

            if(type_var == type_wire) :
                not_append = 0
                for k in range(0,len(xbit_decl_namelist)):
                    if(name == xbit_decl_namelist[k]):
                        new_var = vast.Xbit(name=name,width=new_width,signed=signed,lineno=lineno)
                        new_decl.list.append(new_var)

                for l in range(0,len(xreal_decl_namelist)):
                    if(name == xreal_decl_namelist[l]):
                        new_var = vast.Xreal(name=name,width=new_width,signed=signed,lineno=lineno) 
                        new_decl.list.append(new_var)

            elif(type_var == type_input) :
                not_append = 1
                new_ioport = None

 
                for xbit_name in xbit_port_namelist:
                    if(name == xbit_name):
                        lineno_port = get_port_lineno(portlist_modified,name)
                        remove_port(portlist_modified,name)
                        new_port_dir = vast.Input(name=name,width=new_width,signed=signed,lineno=lineno_port)
                        new_port_type = vast.Xbit(name=name,width=new_width,signed=signed,lineno=lineno_port)
                        new_ioport = vast.Ioport(new_port_dir,new_port_type)
                        #portlist_modified.ports.append(new_ioport)
                        new_ioport_list.append(new_ioport)


                for xreal_name in xreal_port_namelist:
                    if(name == xreal_name):
                        lineno_port = get_port_lineno(portlist_modified,name)
                        remove_port(portlist_modified,name)
                        new_port_dir = vast.Input(name=name,width=new_width,signed=signed,lineno=lineno_port)
                        new_port_type = vast.Xreal(name=name,width=new_width,signed=signed,lineno=lineno_port)
                        new_ioport = vast.Ioport(new_port_dir,new_port_type)
                        #portlist_modified.ports.append(new_ioport)
                        new_ioport_list.append(new_ioport)

                #if(name.find("vdd")!= -1 or name.find("vss")!=-1 or name.find("VDD")!=-1 or name.find("VSS")!=-1):
                #    lineno_port = get_port_lineno(portlist_modified,name)
                #    remove_port(portlist_modified,name)
                #    new_port_dir = vast.Input(name=name,width=new_width,signed=signed,lineno=lineno_port)
                #    new_port_type = vast.Xreal(name=name,width=new_width,signed=signed,lineno=lineno_port)
                #    new_ioport = vast.Ioport(new_port_dir,new_port_type)
                #    #portlist_modified.ports.append(new_ioport)
                #    new_ioport_list.append(new_ioport)


                if(new_ioport == None):
                    lineno_port = get_port_lineno(portlist_pnr,name)
                    remove_port(portlist_modified,name)
                    new_port_dir = vast.Input(name=name,width=new_width,signed=signed,lineno=lineno_port)
                    new_ioport = vast.Ioport(new_port_dir)
  #                  portlist_modified.ports.append(new_ioport)
                    new_ioport_list.append(new_ioport)

            elif(type_var == type_output) :
                not_append = 1
                new_ioport = None
                for xbit_name in xbit_port_namelist:
                    if(name == xbit_name):
                        lineno_port = get_port_lineno(portlist_modified,name)
                        remove_port(portlist_modified,name)
                        new_port_dir = vast.Output(name=name,width=new_width,signed=signed,lineno=lineno_port)
                        new_port_type = vast.Xbit(name=name,width=new_width,signed=signed,lineno=lineno_port)
                        new_ioport = vast.Ioport(new_port_dir,new_port_type)
                        #portlist_modified.ports.append(new_ioport)
                        new_ioport_list.append(new_ioport)


                for xreal_name in xreal_port_namelist:
                    if(name == xreal_name):
                        lineno_port = get_port_lineno(portlist_modified,name)
                        remove_port(portlist_modified,name)
                        new_port_dir = vast.Output(name=name,width=new_width,signed=signed,lineno=lineno_port)
                        new_port_type = vast.Xreal(name=name,width=new_width,signed=signed,lineno=lineno_port)
                        new_ioport = vast.Ioport(new_port_dir,new_port_type)
                        #portlist_modified.ports.append(new_ioport)
                        new_ioport_list.append(new_ioport)

                if(new_ioport == None):
                    lineno_port = get_port_lineno(portlist_pnr,name)
                    remove_port(portlist_modified,name)
                    new_port_dir = vast.Output(name=name,width=new_width,signed=signed,lineno=lineno_port)
                    new_ioport = vast.Ioport(new_port_dir)
 #                   portlist_modified.ports.append(new_ioport)
                    new_ioport_list.append(new_ioport)


            elif(type_var == type_inout) :
                not_append = 1
                new_ioport = None
                for xbit_name in xbit_port_namelist:
                    if(name == xbit_name):
                        lineno_port = get_port_lineno(portlist_modified,name)
                        remove_port(portlist_modified,name)
                        new_port_dir = vast.Inout(name=name,width=new_width,signed=signed,lineno=lineno_port)
                        new_port_type = vast.Xbit(name=name,width=new_width,signed=signed,lineno=lineno_port)
                        new_ioport = vast.Ioport(new_port_dir,new_port_type)
                        #portlist_modified.ports.append(new_ioport)
                        new_ioport_list.append(new_ioport)


                for xreal_name in xreal_port_namelist:
                    if(name == xreal_name):
                        lineno_port = get_port_lineno(portlist_modified,name)
                        remove_port(portlist_modified,name)
                        new_port_dir = vast.Inout(name=name,width=new_width,signed=signed,lineno=lineno_port)
                        new_port_type = vast.Xreal(name=name,width=new_width,signed=signed,lineno=lineno_port)
                        new_ioport = vast.Ioport(new_port_dir,new_port_type)
                        #portlist_modified.ports.append(new_ioport)
                        new_ioport_list.append(new_ioport)

                if(new_ioport == None):
                    lineno_port = get_port_lineno(portlist_pnr,name)
                    remove_port(portlist_modified,name)
                    new_port_dir = vast.Inout(name=name,width=new_width,signed=signed,lineno=lineno_port)
                    new_ioport = vast.Ioport(new_port_dir)
#                    portlist_modified.ports.append(new_ioport)
                    new_ioport_list.append(new_ioporti)

            elif(type_var == type_supply) :
                not_append == 1
                #print("I'm here")
                #print("not append = "+str(not_append))


        if(len(new_decl.list)==0 and not_append == 0):
            decllist_modified.append(decllist_pnr[i])
            #print(decllist_pnr[i].list)
        elif(not_append == 1) :
            pass
        else:
            decllist_modified.append(new_decl)

    for new_ioport in new_ioport_list:
        portlist_modified.ports.append(new_ioport)

    #print(portlist_modified.ports)
    
    return portlist_modified,decllist_modified


def modify_ast_port_decl(ast_model,ast_pnr,name):

    #ast_mod.show()

    name_model,params_model,portlist_model,items_model,remain_module_model = get_module_data(ast_model,name)
    name_pnr,params_pnr,portlist_pnr,items_pnr,remain_module_pnr = get_module_data(ast_pnr,name)

    if(name_pnr==-1):
        return ast_pnr

    decllist_model,remains_model = split_into_decl(items_model)
    decllist_pnr,remains_pnr = split_into_decl(items_pnr)
    
    print("modifying port & decl on "+name_pnr+"...")

    portlist_modified,decllist_modified = port_decl_modify(portlist_model,decllist_model,portlist_pnr,decllist_pnr)

    items_modified = decllist_modified+remains_pnr

    module_new = vast.ModuleDef(name_pnr,params_pnr,portlist_modified,items_modified)

    module_pnr_modified = remain_module_pnr +[module_new]

    description_modified = vast.Description(module_pnr_modified)

    ast_modified = vast.Source(name=None,description=description_modified) 

    return ast_modified

def change_port_decl_type(pnr_verilog):

    ast_model,directives_model = xmodel_parse("top_model.sv") 
    ast_pnr,directives_pnr = xmodel_parse(pnr_verilog)

    namelist = get_module_namelist(ast_model)

    ast_pnr_modified = ast_pnr

    for i in range(0,len(namelist)):
        name = namelist[i]
        ast_pnr_modified = modify_ast_port_decl(ast_model,ast_pnr_modified,name)

    return ast_pnr_modified

def generate_modelfile(ast,name):

    codegen = ASTCodeGenerator()
    rslt = codegen.visit(ast)

    f = open(name+"_post.sv",'w')
    f.write(rslt)
    f.close()

    os.remove("top_model.sv")
    os.remove("xmodel.h")
    os.remove("header.h")
    os.remove("parser.out")
    os.system("rm parsetab.py* -f")
    os.remove("preprocess.output")

def model_file_merge(modellist_file):

    f = open(modellist_file,'r')
    lines = f.readlines()

    for line in lines:
        if(line.find("//")!=-1):
            continue
        elif(line.find("-f")!=-1):
            sublist_dir = line[line.find("-f")+3:line.rfind("/")]
            sublist_file= line[line.rfind("/")+1:line.find("\n")]
            sublist_file = sublist_file.split("\n")
            curdir = os.getcwd()
            os.chdir(sublist_dir)
            submodel_file = model_file_merge(sublist_file[0])
            os.chdir(curdir) 
        elif( (line.find(".sv")!=-1) or (line.find(".v")!=-1) ):
            line = line.split("\n")
            h = open(line[0],'r')
            curdir = os.getcwd()
            os.chdir(main_dir)
            tfx = open("temp.sv",'w')
            tfx.write(h.read())
            tfo = open("top_model_orig.sv",'a+')
            tfx.write(tfo.read())
            tfx.close()
            h.close()
            tfo.close()
            os.system("mv temp.sv top_model_orig.sv")
            os.chdir(curdir)


def model_file_precompile():

    f = open("header.h",'w')
    f.write("`define input_bit       input bit\n")
    f.write("`define output_bit      output bit\n")
    f.write("`define input_real      input real\n")
    f.write("`define output_real     output real\n")
    f.write("`define input_xbit      input xbit\n")
    f.write("`define output_xbit     output xbit\n")
    f.write("`define inout_xbit      inout xbit\n")
    f.write("`define input_xreal     input xreal\n")
    f.write("`define output_xreal    output xreal\n")
    f.write("`define parameter_bit(__name,__value)       parameter bit __name = __value\n")
    f.write("`define parameter_integer(__name,__value)   parameter integer __name = __value\n")
    f.write("`define parameter_real(__name,__value)      parameter real __name = __value\n")
    f.write("`define parameter_string(__name,__value)    parameter string __name = __value\n")
    f.write("`define parameter_realarray(__name)         parameter real __name = 0\n")
    f.write("`define xbit(__name)    xbit __name\n")
    f.write("`define xreal(__name)    xreal __name\n")
    f.write("`define ground          1'b0\n")
    f.write("`define TIME_SCALE       1\n")
    f.write("`define one_xbit        1'b1\n")
    f.write("`define zero_xreal      1'b0\n")
    f.write("`define pow(val1,val2)  val1+val2\n")
    f.write("`define get_timescale\n")
    f.close() 

    g=open("xmodel.h",'w')
    g.close()


    tfo = open("top_model_orig.sv",'r')
    tfp = open("top_model.sv",'w')

    #re_pattern1 = re.compile(r'`parameter_real\(([a-z0-9_]+) ([0-9\[\]\:]+), \'(.+)\)')
    re_pattern1 = re.compile(r'`parameter_real\(([a-z0-9_]+) ([0-9\[\]\:]+), \'([.\{\}0-9a-z,\- ]+)\)')
    re_pattern2 = re.compile(r'integer\'\(([A-Za-z0-9_\[\]]+)\)')
    re_pattern3 = re.compile(r'real\'\(([A-Za-z0-9_\[\]\:\-]+)\)')
    re_pattern4 = re.compile(r'`value\(([A-Za-z0-9_\[\]]+)\)')
    re_pattern5 = re.compile(r'(\'){')

    for line in tfo.readlines():
        line = re.sub(re_pattern1,r'`parameter_realarray(\1)',line)
        line = re.sub(re_pattern2,r'\1',line)
        line = re.sub(re_pattern3,r'\1',line)
        line = re.sub(re_pattern4,r'\1',line)
        line = re.sub(re_pattern5,r'{',line)

        tfp.write(line)

    tfo.close()
    tfp.close()

    os.remove("top_model_orig.sv")

def split_into_inst(items):
    instlist = []
    remains = []

    #print(items)

    for i in range(0,len(items)):
        if(type(items[i]) == type_instancelist):
            instlist.append(items[i]) 
        else :
            remains.append(items[i])

    return instlist,remains

def get_inst_data(inst):
    name = inst.name
    portargs = inst.portlist
    parameterlist = inst.parameterlist
    array = inst.array
    module = inst.module
    lineno = inst.lineno

    return module,name,portargs,parameterlist,array,lineno

def find_xbit_to_bit(instlists):

    if(instlists == []):
        return -1

    xb2blist = []

    for instlist in instlists:
        for inst in instlist.instances:
            if inst.module == "xbit_to_bit":
                module,name,portargs,paramlist,array,lineno = get_inst_data(inst)
                xb2blist.append(instlist)

    if(xb2blist == []):
        return -1

    return xb2blist

def find_portarg(portargs,portname):

    for portarg in portargs:
        if(portarg.portname == portname):
            return portarg

    return -1

def remove_inst_port(portargs,portname):

    portargs = list(portargs)

    for i in range(0,len(portargs)):
        if(portargs[i].portname == portname):
            del portargs[i]
            break

    return portargs

def get_instlist_data(instlist): 

    module = instlist.module
    paramlist = instlist.parameterlist
    instances = list(instlist.instances)
    lineno = instlist.lineno

    return module,paramlist,instances,lineno


def fix_connection_xbit_to_bit(xb2b_lists,instlists_model,decllist_model,instlists_pnr,decllist_pnr):

    xb2b_out_namelist = []

    for xb2b_list in xb2b_lists:
        for xb2b in xb2b_list.instances:
            module,name,portargs,paramlist,array,lineno = get_inst_data(xb2b)
            for portarg in portargs:
                if(portarg.portname=="out"):
                    xb2b_out_namelist.append(portarg.argname)

    inst_namelist = []
    portarg_list = []
    
    inst_to_fix = dict()

    for instlist_model in instlists_model:
        for inst_model in instlist_model.instances:
            module,name,portargs,paramlist,array,lineno = get_inst_data(inst_model)
            for portarg in portargs:
                for xb2b_out_name in xb2b_out_namelist:
                    if(portarg.argname==xb2b_out_name):
                        if(module == "xbit_to_bit"):
                            continue
                        inst_namelist.append(name)
                        portarg_list.append(portarg)
                        inst_to_fix[module] = portarg
        
    for i in range(0,len(instlists_pnr)):
        instlist_pnr = instlists_pnr[i]
        instlist_module,instlist_paramlist,instances,instlist_lineno = get_instlist_data(instlist_pnr)
        for j in range(0,len(instances)):
            inst_pnr = instances[j]
            module,name,portargs,paramlist,array,lineno = get_inst_data(inst_pnr)
            for module_name in inst_to_fix.keys():
                    if(module == module_name):
                        portname = inst_to_fix[module].portname
                        argname = inst_to_fix[module].argname
                        old_portarg = find_portarg(portargs,portname)
                        new_portarg = vast.PortArg(portname,argname,old_portarg.lineno)
                        new_portargs = remove_inst_port(portargs,portname)
                        new_portargs  = [new_portarg] + new_portargs
                        
                        new_inst = vast.Instance(module,name,new_portargs,paramlist,array,lineno)
                        instances[j] = new_inst
                        
                        new_instlist = vast.InstanceList(instlist_module,instlist_paramlist,instances,instlist_lineno) 
                        instlists_pnr[i] = new_instlist
                        break

    for module_name in inst_to_fix.keys():
        new_wire_name = inst_to_fix[module_name].argname.name
        lineno = decllist_pnr[-1].lineno+1 
        new_decl = vast.Decl([vast.Wire(new_wire_name)])
        decllist_pnr.append(new_decl)    

    return instlists_pnr,decllist_pnr

def insert_xbit_to_bit_module(ast_model,ast_pnr,name):

    name_model,params_model,portlist_model,items_model,remain_module_model = get_module_data(ast_model,name)
    name_pnr,params_pnr,portlist_pnr,items_pnr,remain_module_pnr = get_module_data(ast_pnr,name)

    if(name_pnr==-1 or name_model==-1):
        return ast_pnr

    instlists_model,remains_model = split_into_inst(items_model)
    instlists_pnr,remains_pnr = split_into_inst(items_pnr)
    decllist_model,remains_model = split_into_decl(remains_pnr)
    decllist_pnr,remains_pnr = split_into_decl(remains_pnr)
 
    xb2b_lists = find_xbit_to_bit(instlists_model) 

    if(xb2b_lists == -1):
        return ast_pnr

    print("inserting xbit_to_bit in "+name+"...")

    instlists_modified = instlists_pnr+xb2b_lists

    instlists_modified,decllist_modified = fix_connection_xbit_to_bit(xb2b_lists,instlists_model,decllist_model,instlists_modified,decllist_pnr)

    items_modified = decllist_modified+instlists_modified+remains_pnr

    module_new = vast.ModuleDef(name_pnr,params_pnr,portlist_pnr,items_modified)

    module_pnr_modified = remain_module_pnr+[module_new]

    description_modified = vast.Description(module_pnr_modified)

    ast_modified = vast.Source(name=None,description=description_modified) 
    
    #ast_modified.show()

    return ast_modified

def insert_xbit_to_bit(ast_pnr):

    ast_model,directives_model = xmodel_parse("top_model.sv") 

    namelist = get_module_namelist(ast_pnr)

    ast_pnr_modified = ast_pnr

    for i in range(0,len(namelist)):
        name = namelist[i]
        ast_pnr_modified = insert_xbit_to_bit_module(ast_model,ast_pnr_modified,name)
        #break

    return ast_pnr_modified

def find_xbit_decl(decllist):

    namelist = []

    for decl in decllist:
        for var in decl.list:
            lineno,name,width,signed,type_var = get_var_data(var)
            if(type_var == type_xbit):
                namelist.append(name)

    if(namelist == []):
        return -1

    return namelist

def find_xbit_port(portlist):

    namelist = []
    portlist = portlist.ports
    
    for ioport in portlist:
        port_dir,port_type = get_ioport_data(ioport)
        if(type(port_type)==type_xbit):
            namelist.append(port_type.name)
    if(namelist == []):
        return -1

    return namelist

def find_value(list,value):

    for i in range(0,len(list)):
        if(list[i]==value):
            return True
    
    return False


def get_R_in_paramlist(params,port_name):

    if(params.params != ()):
        for paramlist in params.params:
            for param in paramlist.list:
                if(port_name.find("prop")!=-1):
                    if(param.name == "res_out_prop"):
                        return float(param.value.var.value)
                else:
                    if(param.name == "res_out"):
                        return float(param.value.var.value)

    return -1

def get_C_in_paramlist(params):

    if(params.params != ()):
        for paramlist in params.params:
            for param in paramlist.list:
                if(param.name == "cap_in"):
                    return float(param.value.var.value)

    return -1


def find_c_wire(spef_file,net_name,hier_namelist,ast_model):

    f = open(spef_file,'r')
    F = f.read()
    f.close()

    re_pattern1 = re.compile(r'\*D_NET '+net_name+' ([0-9.]+)')

    c_wire = re.findall(re_pattern1,F)
    
    if(c_wire == []):
        net_split = net_name.split('/')
        module = net_split[0]
        port_name = net_split[1]
        module = module.split('0')[0]
        top_module =hier_namelist[hier_namelist.index(module)+1]
        name,params,portlist,items,remain_module = get_module_data(ast_model,top_module)

        instlists,remains = split_into_inst(items)
        print(net_name)
        for instlist in instlists:
            for inst in instlist.instances:
                module,name,portargs,parameterlist,array,lineno = get_inst_data(inst)
                for portarg in portargs:
                    if(portarg.portname == port_name):
                        net_name = portarg.argname.name 


    print(net_name)
    re_pattern1 = re.compile(r'\*D_NET '+net_name+' ([0-9.]+)')

    c_wire = re.findall(re_pattern1,F)

    c_wire = float(c_wire[0])*1e-15

    return c_wire

def add_delay_xbit(module_name,instlists_pnr,decllist_pnr,xbit_decl_namelist,xbit_port_namelist,hier_namelist,ast_model,spef_file):

    xbit_modulelist = []
    for instlist in instlists_pnr:
        for inst in instlist.instances:
            module,name,portargs,parameterlist,array,lineno = get_inst_data(inst)
            if(module=="xbit_to_bit"):
                continue
            if(find_value(hier_namelist,module)): 
                continue           
            for portarg in portargs:
                for xbit_name in xbit_decl_namelist:
                    if(type(portarg.argname) == type_concat):
                        for identifier in portarg.argname.list:
                            if(identifier.name == xbit_name):
                                if(find_value(xbit_modulelist,module)):
                                    continue
                                xbit_modulelist.append(module)

                    else:
                        if(portarg.argname.name == xbit_name):
                            if(find_value(xbit_modulelist,module)):
                                continue
                            xbit_modulelist.append(module)
                for xbit_name in xbit_port_namelist:
                    if(type(portarg.argname) == type_concat):
                        for identifier in portarg.argname.list:
                            if(identifier.name == xbit_name):
                                if(find_value(xbit_modulelist,module)):
                                    continue
                                xbit_modulelist.append(module)

                    else:
                        if(portarg.argname.name == xbit_name):
                            if(find_value(xbit_modulelist,module)):
                                continue
                            xbit_modulelist.append(module)

    xbit_output_portlist = []
    xbit_input_portlist = []
    xbit_rout = dict()
    xbit_cin = dict()

    for xbit_module in xbit_modulelist:
        name,params,portlist,items,remain_module = get_module_data(ast_model,xbit_module)
        if(name == -1):
            print("Error : I/O information of sub-block is not given.")
            sys.exit()
        for ioport in portlist.ports:
            port_dir,port_type = get_ioport_data(ioport)
            if(type(port_dir)==type_output and type(port_type)==type_xbit):
                port_name = port_dir.name
                if(find_value(xbit_output_portlist,port_name)):
                    continue
                xbit_output_portlist.append(port_name)
                xbit_rout[port_name] = get_R_in_paramlist(params,port_name)
                if(xbit_rout[port_name] == -1):
                    return instlists_pnr,decllist_pnr
            if(type(port_dir)==type_input and type(port_type)==type_xbit):
                port_name = port_dir.name
                if(find_value(xbit_input_portlist,port_name)):
                    continue
                xbit_input_portlist.append(port_name)
                xbit_cin[port_name] = get_C_in_paramlist(params)
                if(xbit_cin[port_name] == -1):
                    return instlists_pnr,decllist_pnr

    xbit_output_conn = dict()
    xbit_input_conn = dict()
 
    xbit_argname_list = []

    for i in range(0,len(instlists_pnr)):
        instlist_pnr = instlists_pnr[i]
        instlist_module,instlist_paramlist,instances,instlist_lineno = get_instlist_data(instlist_pnr)
        for j in range(0,len(instances)):
            inst = instances[j]
            module,name,portargs,paramlist,array,lineno = get_inst_data(inst)
            if(find_value(xbit_modulelist,module)==False):
                continue

            for xbit_input_port in xbit_input_portlist:
                for portarg in portargs:
                    if(portarg.portname == xbit_input_port):
                        portname = portarg.portname
                        if(portname.find('prop')!=-1 and ((module =='gro_tdc') or (module =='bbpfd'))):
                            continue
                        #print(module+" : find input port "+xbit_input_port)
                        xbit_input_conn[portarg.argname.name] = xbit_input_port

            for xbit_output_port in xbit_output_portlist:
                for portarg in portargs:
                    if(portarg.portname == xbit_output_port):
                        portname = portarg.portname
                        if(portname.find('prop')!=-1 and ((module =='lcdco') or (module =='ring_dco'))):
                            continue

                        #print(module+" : find output port "+xbit_output_port)
                        xbit_argname_list.append(portarg.argname.name)
                        xbit_output_conn[portarg.argname.name] = xbit_output_port
                        argname = portarg.argname.name+"_not_delayed"
                        arg = vast.Identifier(argname)
                        old_portarg = find_portarg(portargs,portname)
                        new_portarg = vast.PortArg(portname,arg,old_portarg.lineno)
                        new_portargs = remove_inst_port(portargs,portname)
                        new_portargs  = [new_portarg] + new_portargs
                        new_inst = vast.Instance(module,name,new_portargs,paramlist,array,lineno)
                        instances[j] = new_inst
                        portargs = new_portargs
                        
                        new_instlist = vast.InstanceList(instlist_module,instlist_paramlist,instances,instlist_lineno) 
                        instlists_pnr[i] = new_instlist

                        #break

    for xbit_decl_name in xbit_argname_list:

        msb = 0
        xbit_width = None
        for decl in decllist_pnr:
            for var in decl.list:
                lineno,name,width,signed,type_var = get_var_data(var)
                #if(name == xbit_decl_name and width != None):
                #    print(type(width.msb.value))
                if(name == xbit_decl_name):
                    xbit_width = width

        new_decl = vast.Decl([vast.Xbit(xbit_decl_name+"_not_delayed",xbit_width)])
        decllist_pnr.append(new_decl)
    
        xbit_input_port = xbit_input_conn[xbit_decl_name]
        xbit_output_port = xbit_output_conn[xbit_decl_name]

        rout = xbit_rout[xbit_output_port]
        cin = xbit_cin[xbit_input_port]

        net_name = xbit_decl_name
        for i in range(0,len(hier_namelist)):
            if(hier_namelist[i] == module_name):
                break
            if(hier_namelist[i+1] == "dpll"):
                net_name = hier_namelist[i+1]+"0/"+net_name
            else:
                net_name = hier_namelist[i+1]+"/"+net_name

        if(xbit_width!=None):
            msb = int(xbit_width.msb.value)
            lsb = int(xbit_width.lsb.value)

        if(msb==0):
            c_wire = find_c_wire(spef_file,net_name,hier_namelist,ast_model)
            delay = log(2)*rout*(cin+c_wire)
            print("delay for "+xbit_decl_name+" is "+str(delay))
            in_arg = vast.Identifier(xbit_decl_name+"_not_delayed")
            out_arg = vast.Identifier(xbit_decl_name)
            in_port = vast.PortArg("in",in_arg)
            out_port = vast.PortArg("out",out_arg)
            portargs = [in_port,out_port]
            new_param = vast.ParamArg("delay",vast.FloatConst(str(delay)))
            #new_param = vast.ParamArg("delay",vast.FloatConst(str(0)))
            paramargs = [new_param]
            new_inst = vast.Instance("delay_xbit","delay_xbit_"+xbit_decl_name,portargs,paramargs)
            new_instances = [new_inst]
            new_instlist = vast.InstanceList("delay_xbit",paramargs,new_instances) 
            instlists_pnr.append(new_instlist)


        else:
            for i in range(lsb,msb+1):
                net_name_indexed = net_name+".."+str(i)+".."
                c_wire = find_c_wire(spef_file,net_name_indexed,hier_namelist,ast_model)
                delay = log(2)*rout*(cin+c_wire)
                print("delay for "+xbit_decl_name+"["+str(i)+"]"+" is "+str(delay))
                in_arg = vast.Identifier(xbit_decl_name+"_not_delayed"+"["+str(i)+"]")
                out_arg = vast.Identifier(xbit_decl_name+"["+str(i)+"]")
                in_port = vast.PortArg("in",in_arg)
                out_port = vast.PortArg("out",out_arg)
                portargs = [in_port,out_port]
                new_param = vast.ParamArg("delay",vast.FloatConst(str(delay)))
                #new_param = vast.ParamArg("delay",vast.FloatConst(str(0)))
                paramargs = [new_param]
                new_inst = vast.Instance("delay_xbit","delay_xbit_"+xbit_decl_name+"_"+str(i),portargs,paramargs)
                new_instances = [new_inst]
                new_instlist = vast.InstanceList("delay_xbit",paramargs,new_instances) 
                instlists_pnr.append(new_instlist)

    return instlists_pnr,decllist_pnr

def insert_delay_xbit_module(ast_model,ast_pnr,spef_file,name,hier_namelist):

    hier_namelist.reverse()

    name_model,params_model,portlist_model,items_model,remain_module_model = get_module_data(ast_model,name)
    name_pnr,params_pnr,portlist_pnr,items_pnr,remain_module_pnr = get_module_data(ast_pnr,name)

    if(name_pnr==-1 or name_model==-1):
        return ast_pnr

    instlists_model,remains_model = split_into_inst(items_model)
    instlists_pnr,remains_pnr = split_into_inst(items_pnr)
    decllist_model,remains_model = split_into_decl(remains_pnr)
    decllist_pnr,remains_pnr = split_into_decl(remains_pnr)

    xbit_decl_namelist = find_xbit_decl(decllist_pnr)
    xbit_port_namelist = find_xbit_port(portlist_pnr)

    if(xbit_decl_namelist == -1 and xbit_port_namelist == -1):
        return ast_pnr

    print("inserting delay_xbit in "+name+"...")

    instlists_modified,decllist_modified = add_delay_xbit(name,instlists_pnr,decllist_pnr,xbit_decl_namelist,xbit_port_namelist,hier_namelist,ast_model,spef_file)

    items_modified = decllist_modified+instlists_modified+remains_pnr

    module_new = vast.ModuleDef(name_pnr,params_pnr,portlist_pnr,items_modified)

    module_pnr_modified = remain_module_pnr+[module_new]

    description_modified = vast.Description(module_pnr_modified)

    ast_modified = vast.Source(name=None,description=description_modified) 

    return ast_modified

def insert_delay_xbit(ast_pnr,spef_file):

    ast_model,directives_model = xmodel_parse("top_model.sv")
    
    namelist = get_module_namelist(ast_pnr)

    ast_pnr_modified = ast_pnr

    for i in range(0,len(namelist)):
        name = namelist[i]
        ast_pnr_modified = insert_delay_xbit_module(ast_model,ast_pnr_modified,spef_file,name,namelist)

    return ast_pnr_modified

def get_top_name(ast):

    namelist = get_module_namelist(ast)

    return namelist[-1]

def main():
    INFO = "postnetlisting of pnr verilog file"
    USAGE = "Usage: post_netlist.py modellist_file(.f) pnr_verilog_file(.sv) spef_file(.spef) sdf_file(.sdf)"

    def __init__():
        os.system("rm top_model.sv -f")

    def showusage():
        print(INFO)
        print(USAGE)
        sys.exit()

    optparser = OptionParser(description = INFO, usage = USAGE )
    (options, args) = optparser.parse_args()

    filelist = args

    for f in filelist:
        if not os.path.exists(f): raise IOError("file not found: " + f)

    if len(filelist) != 3:
        showusage()


    modellist_file =  filelist[0]  
    pnr_verilog_file =  filelist[1]  
    spef_file =  filelist[2]  

    model_file_merge(modellist_file)

    model_file_precompile()

    ast_pnr_modified = change_port_decl_type(pnr_verilog_file)

    ast_pnr_modified = insert_xbit_to_bit(ast_pnr_modified)

    ast_pnr_modified = insert_delay_xbit(ast_pnr_modified,spef_file)

    top_name = get_top_name(ast_pnr_modified)

    generate_modelfile(ast_pnr_modified,top_name)

if __name__ == '__main__':
    main()
