/*----------------------------------------------------------------------
TESTBENCH tb_prescaler.sv

= Purpose =

A testbench to verify the division factor of the prescaler module.

= Description =

A clock generator(clk_gen) feeds a constant-frequency clock to the prescaler. The output frequencies of various dividers are measured to check its division accuracy.

= Revisions =

$Authors$
$DateTIme$
$Id$
----------------------------------------------------------------------*/

`include "xmodel.h"

module tb_prescaler();

    parameter real freq_in = 1.0e9;

    bit reset_n;
    xbit clk_inp, clk_inn;
    xbit clk_outp, clk_outn;

    reg [1:0] div_sel;
    reg vdd = 1;
    reg vss = 0;

    // stimuli
    initial begin
        reset_n = 1'b1;
        div_sel = 2'b0;
        #(1e-9/`TIME_SCALE) reset_n = 1'b0;
        #(5e-9/`TIME_SCALE) reset_n = 1'b1;
    end

    clk_gen #(.init_phase(0), .freq(freq_in)) clk_in0(clk_inp);
    clk_gen #(.init_phase(M_PI), .freq(freq_in)) clk_in1(clk_inn);

    // DUT
    prescaler DUT(.vdd(vdd), .vss(vss),
                    .clk_inp(clk_inp), .clk_inn(clk_inn),
                    .reset_n(reset_n), .div_sel(div_sel),
                    .clk_outp(clk_outp), .clk_outn(clk_outn));

    // probing
//    real div_sel_r;
//    always @(div_sel) begin
//        div_sel_r = real'(div_sel);
//    end

    probe_xbit probe_clk_inp(clk_inp);
    probe_xbit probe_clk_inn(clk_inn);
    probe_xbit probe_clk_outp(clk_outp);
    probe_xbit probe_clk_outn(clk_outn);
    probe_freq probe_freq_out(clk_outp);
    probe_bit  probe_reset_n(reset_n);
//    probe_real probe_div_sel(div_sel_r);

endmodule
