#!/usr/bin/env python
"""
SCRIPT plot_d2f.py

= Purpose =
plotting graphs of the testbench(tb_lcdco_d2f.sv) simulation result

= Description =
input code vs frequency
input code vs relative gain

= Outputs =


= Plots =
|| '''Graph Name''' || '''Filename''' || '''Description''' ||
|| Frequency VS input code || freq.png || frequency vs input code ||
|| Relative gain VS input code || relative_gain.png || relative gain vs input code ||
"""

##-------------------------------------------------------------------
## import modules
##-------------------------------------------------------------------

from  pylab import *
import numpy as np
import  matplotlib.pyplot as plt

##-------------------------------------------------------------------
## class plot_d2f
##-------------------------------------------------------------------

code = []
freq = []
rgain = list()

with open('result.txt', 'r') as f:
    data = f.readlines()

for line in data[1:]:
    data_split = line.split()
    code.append(int(data_split[0]))
    freq.append(float(data_split[1]))

for i in range(0,1024) :
    if((i >= 16) & (i <= 1007)) :
        rgain = np.append(rgain, (freq[i+16]/freq[i-16])**(1.0/32))

freq = np.array(freq)/1.0e9
rgain_avg = 10**(np.mean(np.log10(np.array(rgain)))) - 1
rgain = np.array(rgain) - 1

plt.figure(1)
plt.plot(code, freq, marker='o', linestyle='--', color='g')
plt.title("Frequency vs input code")
plt.xlabel("Input code")
plt.ylabel("Frequency [GHz]")

plt.figure(2)
plt.plot(code[15:1007], rgain, marker = 'o', linestyle='-', color='r', label=('relative gain avg = %.5f'%rgain_avg))
plt.legend()
plt.title("Relative gain vs input code")
plt.xlabel("Input code")
plt.ylabel("Relative gain")
plt.ylim([0, np.max(rgain)*1.3])
plt.axhline(y=(rgain_avg*1.2), linewidth=0.5, linestyle='--', color='k', alpha = 0.8)
plt.axhline(y=(rgain_avg*0.8), linewidth=0.5, linestyle='--', color='k', alpha = 0.8)

plt.show()
