/*----------------------------------------------------------------------
TESTBENCH tb_bbpd.sv

= Purpose =

A testbench to test the polarity of the bang-bang phase detector outputs.

= Description =

The testbench feeds reference and feedback clocks with slight different period, and checks the polarity of up and down output signals.

= Revisions =

$Authors$
$DateTime$
$Id$
----------------------------------------------------------------------*/

`include "xmodel.h"

module tb_bbpd();

    parameter real freq_ref = 130.0e6;
    parameter real freq_fb = 125.0e6;
    
    xbit clk_ref, clk_fb;

    reg vdd = 1;
    reg vss = 0;
    wire up, dn;

    // stimuli
    clk_gen #(.init_phase(0), .freq(freq_ref)) clk_gen_ref(clk_ref);
    clk_gen #(.init_phase(0), .freq(freq_fb)) clk_gen_fb(clk_fb);

    // DUT
    bbpd DUT (
        .vdd(vdd), .vss(vss),
        .clk_ref(clk_ref), .clk_fb(clk_fb),
        .up(up), .dn(dn)
    );

    // probing
    probe_xbit  probe_clk_ref(clk_ref);
    probe_xbit  probe_clk_fb(clk_fb);
    probe_bit   probe_up(up);
    probe_bit   probe_dn(dn);

//    initial begin
//        $xmodel_dumpfile();
//        $xmodel_dumpvars();
//    end

endmodule
