# Get default settings
source -echo ./tcl/digital_lf.tcl

set LOG_PATH                        "./pt_log"
set RPT_FILE                        "pt_${DESIGN}.rpt"

## Logical library files ------------------------------------------------------
set_app_var search_path     "${LIBDIR}"
set_app_var target_library  "${LIBDIR}/cello.slow.db"
set_app_var link_library    "${LIBDIR}/cello.slow.db"
#set_app_var link_library    "${LIBDIR}/cello.slow.db ${LIBDIR}/cello.fast.db ${LIBDIR}/cello.typ.db"

read_verilog ${PROJDIR}/${DESIGN}_mapped.sv
link_design ${DESIGN}

read_sdc ${PROJDIR}/${DESIGN}_mapped.sdc -version 1.9
read_sdf -analysis_type on_chip_variation ${OUTDIR}/${DESIGN}/${DESIGN}_mapped.sdf


check_timing -verbose >> "${LOG_PATH}/${RPT_FILE}"
check_constraints -verbose >> "${LOG_PATH}/${RPT_FILE}"

report_timing >> "${LOG_PATH}/${RPT_FILE}"
report_clock_timing -type summary >> "${LOG_PATH}/${RPT_FILE}"
report_constraint -all_violators -verbose  >> "${LOG_PATH}/${RPT_FILE}"
report_analysis_coverage -status_details {met untested} >> "${LOG_PATH}/${RPT_FILE}"

exit
