/*----------------------------------------------------------------------
MODULE stm_add4

= Purpose =
A stimulus generator for module add4

= Description =
Generating the two 4-bit inputs A and B in a random fashion.
----------------------------------------------------------------------*/

module stm_add4 (
    output reg [3:0] A, B,
    output reg clk
);

initial clk = 0;
always  #(0.5ns) clk = ~clk;

always @(posedge clk) begin
    A = $urandom_range(15, 0);
    B = $urandom_range(15, 0);
end

endmodule
