/*----------------------------------------------------------------------
MODULE mon_add4

= Purpose =
An output monitor for module add4

= Description =
Demonstrating the use of checkers to examine whether the results
are correct or not.
----------------------------------------------------------------------*/

module mon_add4 (
    input [3:0] A, B,
    input [3:0] S,
    input C,
    input clk
);

wire [4:0] sum;
assign sum = {C, S[3:0]};

always @(negedge clk) begin
    if (sum == A + B)
        $display("CORRECT: A=%b, ", A, "B=%b: ", B, "S=%b, ", S, "C=%b", C);
    else
        $display("WRONG  : A=%b, ", A, "B=%b: ", B, "S=%b, ", S, "C=%b", C);
end

endmodule
