# Makefile ----------------------------------------------------------------
DEPEND_CELLVIEWS = dpll:dpll:schematic
DEPEND_FILES = tb_pnoise.sv cmd.py
SOURCES = -f sources.f tb_pnoise.sv
TOPMODULE = tb_pnoise

SIMTIME = 30us
TIMESCALE = 1ps/1ps
SIMULATOR = vcs
SIMOPTS = 

all: runsim plotwave

runsim:
	xmodel $(SOURCES) --top $(TOPMODULE) --simtime $(SIMTIME) \
	       --timescale $(TIMESCALE) --simulator $(SIMULATOR) $(SIMOPTS)
	xwave -c cmd.py

plotwave:
	xwave xmodel.jez --stdin

clean:
	xmodel --clean --simulator $(SIMULATOR)

