# Makefile ----------------------------------------------------------------
DEPEND_CELLVIEWS = dpll:dpll:schematic
DEPEND_FILES = tb_jtran.sv.empy tb_jtran.py
SOURCES = -f sources.f
TOPMODULE = tb_jtran

SIMTIME = 100ns
TIMESCALE = 1ps/1ps
SIMULATOR = vcs
SIMOPTS = 

all: runsim plotwave

runsim:
	xmodelpy tb_jtran.py --freq_ref 125.0e6 --t_lock 15.0e-6 \
	        --freq_max 20e6 --freq_min 0.2e6 --num_sweep 15 \
	        --cmd sources.f --source tb_jtran.sv.empy \
	        --var tb_jtran.clk_fb

plotwave:
	xwave xmodel.jez --stdin

clean:
	xmodel --clean --simulator $(SIMULATOR)

