/*----------------------------------------------------------------------
TESTBENCH tb_gro_tdc.sv

= Purpose =

A testbench to test the polarity of the gated-relaxation oscillator based time-to-digital converter outputs.

= Description =

The testbench feeds reference and feedback clocks with slight different period, and checks the polarity of up and down output signals.

= Revisions =

$Authors$
$DateTime$
$Id$
----------------------------------------------------------------------*/

`include "xmodel.h"

module tb_gro_tdc();

    parameter real freq_ref = 130.0e6;
    parameter real freq_fb = 125.0e6;

    xbit clk_ref, clk_fb;

    reg reset_n;
    reg [1:0] f_range;
    wire [5:0] up, dn;
    xbit prop_up, prop_dn;

    reg vdd = 1;
    reg vss = 0;

    real up_r, dn_r;
    real f_bias_r;
    
    // stimuli
    initial begin
        reset_n = 1'b1;
        f_range = 2'b10;
        #(1e-9/`TIME_SCALE) reset_n = 1'b0;
        #(5e-9/`TIME_SCALE) reset_n = 1'b1;
    end

    clk_gen #(.freq(freq_ref)) clk_gen_ref(clk_ref);
    clk_gen #(.freq(freq_fb)) clk_gen_fb(clk_fb);

    // DUT
    gro_tdc DUT (.reset_n(reset_n),
        .vdd(vdd), .vss(vss),
        .f_range(f_range),
        .clk_ref(clk_ref), .clk_fb(clk_fb),
        .up(up), .dn(dn), .prop_up(prop_up), .prop_dn(prop_dn)
    );

    always @(up or dn or DUT.f_bias) begin
        up_r = real'(up);
        dn_r = real'(dn);
        f_bias_r = real'(DUT.f_bias);
    end

    // probing
    probe_xbit  probe_clk_ref(clk_ref);
    probe_xbit  probe_clk_fb(clk_fb);
    probe_bit   probe_reset_n(reset_n);
    probe_xbit  probe_prop_up(prop_up);
    probe_xbit  probe_prop_dn(prop_dn);
    probe_real  probe_up(up_r);
    probe_real  probe_dn(dn_r);

endmodule
