/*----------------------------------------------------------------------
MODEL div8_mphase.sv

= Purpose =

A divided-by-8 block that generates multi-phase outputs

= Description =

The block consists of 4 differential flip-flops in ring configuration.

= Revisions =

$Authors$
$DateTime$
$Id$
----------------------------------------------------------------------*/

module div8_mphase #(
    `parameter_real(delay_cq, 242e-12),     // clock-to-output delay
    `parameter_real(cap_in, 1.8e-15),       // equivalent input capacitance
    `parameter_real(res_out, 2.1e4)         // equivalent output resistance
)(
    input vdd,
    input vss,
    `input_xbit clk_inp,        // clock input(pos)
    `input_xbit clk_inn,        // clock input(neg)
    input reset_n,              // divider reset (active low)
    `output_xbit [7:0] clk_out  // divided clock outputs
);

    xbit rst;
    xbit div0, divb0;

    bit_to_xbit conn0(.in(~reset_n), .out(rst));

    dff_rst_async_xbit #(.delay_cq(delay_cq))
        dff0(.d(clk_out[7]), .q(div0), .clk(clk_inp), .rst(rst));
    dff_rst_async_xbit #(.delay_cq(delay_cq))
        dff1(.d(clk_out[6]), .q(clk_out[7]), .clk(clk_inp), .rst(rst));
    dff_rst_async_xbit #(.delay_cq(delay_cq))
        dff2(.d(clk_out[5]), .q(clk_out[6]), .clk(clk_inp), .rst(rst));
    dff_rst_async_xbit #(.delay_cq(delay_cq))
        dff3(.d(clk_out[4]), .q(clk_out[5]), .clk(clk_inp), .rst(rst));
    inv_xbit    inv0(.in(div0), .out(clk_out[4]));

    dff_set_async_xbit #(.delay_cq(delay_cq))
        dff0_b(.d(clk_out[3]), .q(divb0), .clk(clk_inn), .set(rst));
    dff_set_async_xbit #(.delay_cq(delay_cq))
        dff1_b(.d(clk_out[2]), .q(clk_out[3]), .clk(clk_inn), .set(rst));
    dff_set_async_xbit #(.delay_cq(delay_cq))
        dff2_b(.d(clk_out[1]), .q(clk_out[2]), .clk(clk_inn), .set(rst));
    dff_set_async_xbit #(.delay_cq(delay_cq))
        dff3_b(.d(clk_out[0]), .q(clk_out[1]), .clk(clk_inn), .set(rst));
    inv_xbit    inv1(.in(divb0), .out(clk_out[0]));

endmodule
