/*----------------------------------------------------------------------
TESTBENCH tb_div8_mphase.sv

= Purpose =

A testbench to verify the division factor of the div8_mphase module.

= Description =

A clock generator(clk_gen) feeds a constant-frequency clock to the div8_mphase. The output frequencies of various div8_mphases are measured to check its division accuracy.

= Revisions =

$Authors$
$DateTIme$
$Id$
----------------------------------------------------------------------*/

`include "xmodel.h"

module tb_div8_mphase();

    parameter real freq_in = 1.0e9;

    bit reset_n;
    xbit clk_inp, clk_inn;
    xbit [7:0] clk_out;

    supply1 vdd;
    supply0 vss;

    // stimuli
    initial begin
        reset_n = 1'b1;
        #(1e-9/`TIME_SCALE) reset_n = 1'b0;
        #(5e-9/`TIME_SCALE) reset_n = 1'b1;
    end

    clk_gen #(.init_phase(0), .freq(freq_in)) clk_in0(clk_inp);
    clk_gen #(.init_phase(M_PI), .freq(freq_in)) clk_in1(clk_inn);

    // DUT
    div8_mphase DUT(.vdd(vdd), .vss(vss),
                    .clk_inp(clk_inp), .clk_inn(clk_inn),
                    .reset_n(reset_n), .clk_out(clk_out));

    // probing
    probe_xbit probe_clk_inp(clk_inp);
    probe_xbit probe_clk_inn(clk_inn);
    probe_bit  probe_reset_n(reset_n);
    probe_xbit probe_clk_out0(clk_out[0]);
    probe_xbit probe_clk_out1(clk_out[1]);
    probe_xbit probe_clk_out2(clk_out[2]);
    probe_xbit probe_clk_out3(clk_out[3]);
    probe_xbit probe_clk_out4(clk_out[4]);
    probe_xbit probe_clk_out5(clk_out[5]);
    probe_xbit probe_clk_out6(clk_out[6]);
    probe_xbit probe_clk_out7(clk_out[7]);

endmodule
