
#####################################################
#    Synthesis for Time Synchronization                
#####################################################

## Set design variable --------------------------------------------------------
set search_path [list ${PROJDIR} ${LIBDIR} ${synopsys_root}/libraries/syn ${synopsys_root}/dw/syn_ver ${synopsys_root}/dw/sim_ver]
set revName         "${DESIGN}_mapped"
set designName      "${DESIGN}"
set outputName      "${DESIGN}"
set file_svf        "${OUTDIR}/${outputName}/${revName}.svf"
set_svf ${file_svf}

## Logical library files ------------------------------------------------------
set_app_var search_path     "${LIBDIR}"
set_app_var target_library  "${LIBDIR}/cello.slow.db"
set_app_var link_library    "${LIBDIR}/cello.slow.db ${LIBDIR}/cello.fast.db ${LIBDIR}/cello.typ.db dw_foundation.sldb"
## From synopsys_dc.set (deleted)
set synthetic_library {dw_foundation.sldb}

## Output Path ----------------------------------------------------------------
set file_report             "${OUTDIR}/${outputName}/${revName}.rpt"
set file_timing_report      "${OUTDIR}/${outputName}/${revName}.timing.rpt"
set file_qor_timing_report  "${OUTDIR}/${outputName}/${revName}.qor.timing.rpt"
set file_check              "${OUTDIR}/${outputName}/${revName}.check"
set file_stamp              "${OUTDIR}/${outputName}/${revName}.stamp"
set file_db                 "${OUTDIR}/${outputName}/${revName}.db"
set file_verilog            "${OUTDIR}/${outputName}/${revName}.v"
set file_verilog_for_sim    "${PROJDIR}/${revName}.sv"
set file_ddc                "${OUTDIR}/${outputName}/${revName}.ddc"
set file_sdc                "${OUTDIR}/${outputName}/${revName}.sdc"
set file_sdc_for_pt         "${PROJDIR}/${revName}.sdc"
set file_eleborate_report   "${OUTDIR}/${outputName}/${revName}.rpt"
set file_sdf                "${OUTDIR}/${outputName}/${revName}.sdf"
set file_sdf_for_sim        "${PROJDIR}/${revName}.sdf"


## Output auto generation -----------------------------------------------------
    sh mkdir ${OUTDIR}/${outputName}/work
    define_design_lib work -path ${OUTDIR}/${outputName}/work

echo > ${file_report}
echo > ${file_check}

## Make & set cache folder (20150415, syjung)----------------------------------
set HOME_DIR        [getenv HOME]
set CACHE_DIR       "${HOME_DIR}/tmp"
sh mkdir -p ${CACHE_DIR}
set_app_var cache_read  ${CACHE_DIR}
set_app_var cache_write ${CACHE_DIR}


#####################################################
#              Read Code
#####################################################

## Analyzation ----------------------------------------------------------------

## Input verilog files (all hierarchical modules)

## Topdir ##

analyze -f verilog -define "SYN" ${PROJDIR}/${Topmodule}
analyze -f verilog -define "SYN" ${PROJDIR}/${Submodule_1}
analyze -f verilog -define "SYN" ${PROJDIR}/${Submodule_2}
analyze -f verilog -define "SYN" ${PROJDIR}/${Submodule_3}
analyze -f verilog -define "SYN" ${PROJDIR}/${Submodule_4}
analyze -f verilog -define "SYN" ${PROJDIR}/${Submodule_5}
analyze -f verilog -define "SYN" ${PROJDIR}/${Submodule_6}
analyze -f verilog -define "SYN" ${PROJDIR}/${Submodule_7}

## Subdir1 ##

## Subdir2 ##

## Subdir3 ##

## Elaboration ---------------------------------------------------------------- 

elaborate ${designName} >> ${file_eleborate_report} 
current_design ${designName}

## Flatten design for primetime; you should have no hierarchy (20150415, syjung)
ungroup -all -flatten 


## Compilation ----------------------------------------------------------------

source ${SYNDIR}/constraints/constraints_${DESIGN}.tcl

compile
compile -exact_map -map_effort high -incremental_mapping
compile_ultra
compile_ultra -timing_high_effort_script
compile_ultra -incremental
compile_ultra -incremental
compile_ultra -incremental
compile_ultra -incremental

define_name_rules verilog -remove_internal_net_bus
change_names -rules verilog -hier

## Dump output files-----------------------------------------------------------

write -hierarchy -format verilog -output ${file_verilog}

write -hierarchy -format verilog -output ${file_verilog_for_sim}

write -hierarchy -format ddc -output ${file_ddc}

write_sdf -version 2.1 ${file_sdf}
write_sdf -version 2.1 ${file_sdf_for_sim}

write_sdc ${file_sdc}
write_sdc ${file_sdc_for_pt}

## Report Timing --------------------------------------------------------------

report_timing -max_paths 10000 >> ${file_report}
report_timing_requirement >> ${file_report}
report_timing -delay min -max_path 10000 >> ${file_report}
report_constraint -verbose >>  ${file_timing_report}
report_area -hier >> ${file_report}
report_power -hier >> ${file_report}
check_design >> ${file_check}
#redirect -file ${file_qor_timing_report} {report_qor_snapshot -no_display}

check_timing

exit
