#!/usr/bin/env python
# Myeong-Jae Park, Jan. 13, 2013
from pylab import *
import optparse

description = "Pad constraint generation script"
usage = "%prog [options] [filename]"
parser = optparse.OptionParser(description=description, usage=usage)
parser.add_option('-s', action="store", type="string", dest="side", help="Left/Right/Top/Bottom", default="Bottom")
parser.add_option('-d', action="store", type="float", dest="dx", help="Pad spacing", default=200.0)
parser.add_option('-i', action="store", type="float", dest="start", help="Starting point (Left most for Top/Bottom, Lowest for Left/Right", default=None)
(options, args) = parser.parse_args()

header = {'Left':1, 'Top':2, 'Right':3, 'Bottom':4}
side = options.side

fr = open(args[0], 'r')
lines = fr.readlines()
fw = open(args[0]+'.tcl', 'w')
fw.write('#Created by pad_const_parser.py\n')
for i in range(len(lines)):
    if options.start == None:
        index = i - len(lines)/2.0 + 0.5
        location = options.dx*index
    else:
        location = options.start + options.dx*i


    fw.write('set_pad_physical_constraints -pad_name "G%s_%d" -side %d -order %d -offset %.2f\n' %(header[options.side], i+1, header[options.side], i+1, location))

#    if i==0:
#        fw.write('set_pad_physical_constraints -pad_name "G%s_%d" -side %d -order %d -offset %.2f\n' %(header[options.side], i+1, header[options.side], i+1, location))
#        fw.write('set_pad_physical_constraints -pad_name "G%s_%d" -side %d -order %d -min_left_iospace 0 -min_right_iospace 0\n' %(header[options.side], i+1, header[options.side], i+1))
#    else:
 #       fw.write('set_pad_physical_constraints -pad_name "G%s_%d" -side %d -order %d -min_left_iospace 0 -min_right_iospace 0\n' %(header[options.side], i+1, header[options.side], i+1))


fw.close()
