################################################################################
# power_syn.tcl : power synthesizer makes power straps which are imprinted in various power/ground domain and look inside std/custom cells for auto-via insertion
################################################################################

source -echo ./icc_scripts/init_setup.tcl
open_mw_cel ${DESIGN}

# Perservation of floorplan & placement ----------------------------------------
change_selection [get_cells -all -hierarchical -filter \
    {ref_name=="XOR2_X1"    \
    || ref_name=="OAI22_X1" \
    || ref_name=="OAI21_X1" \
    || ref_name=="NOR3_X1"  \
    || ref_name=="NOR2_X1"  \
    || ref_name=="NAND3_X1" \
    || ref_name=="NAND2_X1" \
    || ref_name=="MUXI2_X1" \
    || ref_name=="MUX2_X1"  \
    || ref_name=="INV_X8"   \
    || ref_name=="INV_X4"   \
    || ref_name=="INV_X2"   \
    || ref_name=="INV_X16"  \
    || ref_name=="INV_X1"   \
    || ref_name=="FILL_X1"  \
    || ref_name=="FILLCAP_X8" \
    || ref_name== "FILLCAP_X1" \
    || ref_name=="FILLCAP_X2"  \
    || ref_name=="FILLCAP_X4"  \
    || ref_name=="FILLCAP_X16"  \
    || ref_name=="DFF_X2"      \
    || ref_name=="DFF_X1"      \
    || ref_name=="DFF_SETB_X1" \
    || ref_name=="DFF_RSTB_X1" \
    || ref_name=="AOI22_X1"    \
    || ref_name=="ADDF_X1"    \
    || ref_name=="INV_X32"    \
    || ref_name=="INV_X64"    \
    || ref_name=="INV_X128"    \
    || ref_name=="AOI21_X1"}]

set_object_fixed_edit [get_selection] 1
## ------------------------------------------------------------------------------
#
##removing placement blockage
remove_placement_blockage -all
#
## Power-strap synthesizer ------------------------------------------------------
##Vertical power strap--------------------------------------------------------
#
# DPLL power syn
create_power_straps \
    -extend_low_ends to_first_target \
    -extend_high_ends to_first_target \
    -direction vertical -layer ${POWER_STRAP_LAYER_V} \
    -step $STRAP_INCREMENT_V -nets  "$DPLL_POWER_NET $GROUND_NET $TEST_POWER_NET $GROUND_NET"  \
    -start_at $DPLL_STRAP_START_X_V \
    -stop     $DPLL_STRAP_STOP_X_V  \
    -start_low_ends  coordinate  -start_low_ends_coordinate  $DPLL_STRAP_START_Y_V \
    -start_high_ends coordinate  -start_high_ends_coordinate $DPLL_STRAP_STOP_Y_V  \
    -width $POWER_STRAP_WIDTH_V -pitch_within_group $POWER_STRAP_PITCH_V \
    -configure step_and_stop \
    -look_inside_std_cells -keep_floating_wire_pieces

save_mw_cel ${DESIGN}
copy_mw_cel -from ${DESIGN} -to ${DESIGN}_POWER_CUSTOM

exit
