################################################################################
# pg_imprinting.tcl : power/ground imprinting script disignates all the power or ground pins of the design
################################################################################

source -echo ./icc_scripts/init_setup.tcl
open_mw_cel ${DESIGN}

# vdda domain -----------------------------------------------------------------

derive_pg_connection\
    -power_net "$DPLL_POWER_NET" -ground_net "$GROUND_NET" \
    -power_pin "$DPLL_ANALOG_POWER_PIN" -ground_pin "$DPLL_GROUND_PIN" \
    -cells {dpll0/*} -reconnect

derive_pg_connection\
    -power_net "$DPLL_POWER_NET" -ground_net "$GROUND_NET" \
    -power_pin "$STD_POWER_PIN" -ground_pin "$STD_GROUND_PIN" \
    -cells {dpll0/*} -reconnect

# vddt domain -----------------------------------------------------------------

derive_pg_connection\
    -power_net "$TEST_POWER_NET" -ground_net "$GROUND_NET" \
    -power_pin "$STD_POWER_PIN" -ground_pin "$STD_GROUND_PIN" \
    -cells {U*} -reconnect

derive_pg_connection\
    -power_net "$TEST_POWER_NET" -ground_net "$GROUND_NET" \
    -power_pin "$TEST_POWER_PIN" -ground_pin "$TEST_GROUND_PIN" \
    -cells {out_cml*} -reconnect

derive_pg_connection\
    -power_net "$TEST_POWER_NET" -ground_net "$GROUND_NET" \
    -power_pin "$TEST_POWER_PIN" -ground_pin "$TEST_GROUND_PIN" \
    -cells {in_csda*} -reconnect

# vdd/vss tie hi/lo

derive_pg_connection -power_net "$DPLL_POWER_NET" -ground_net "$GROUND_NET" -tie -cells {dpll0*}

derive_pg_connection -power_net "$TEST_POWER_NET" -ground_net "$GROUND_NET" -tie -cells {G*}

derive_pg_connection -power_net "$TEST_POWER_NET" -ground_net "$GROUND_NET" -tie -cells {out_cml*}

# ------------------------------------------------------------------------------

save_mw_cel ${DESIGN}
copy_mw_cel -from ${DESIGN} -to ${DESIGN}_PGIMP

exit
