################################################################################
# insert_filler.tcl : this script fills empty spaces in standard cell rows with filler cells which act as decoupling capacitors
################################################################################

source -echo ./icc_scripts/init_setup.tcl
open_mw_cel ${DESIGN}

remove_voltage_area -all

# filler removal (for iteration) -----------------------------------------------
remove_stdcell_filler -stdcell -bounding_box "$FILLER_TOT_AREA"  
# ------------------------------------------------------------------------------

# Stdcell-type filler insertion ------------------------------------------------

#vddt filler insertion
insert_stdcell_filler \
    -cell_without_metal "$FILLER_ARRAY" \
    -bounding_box $FILLER_TOT_AREA \
    -connect_to_power "$TEST_POWER_NET" -connect_to_ground "$GROUND_NET" \
    -randomize 

remove_stdcell_filler -bounding_box "$DPLL_FILLER_AREA" -stdcell

#vdda filler insertion
insert_stdcell_filler \
    -cell_without_metal "$FILLER_ARRAY" \
    -bounding_box $DPLL_FILLER_AREA \
    -connect_to_power "$DPLL_POWER_NET" -connect_to_ground "$GROUND_NET" \
    -randomize

# ------------------------------------------------------------------------------

save_mw_cel ${DESIGN}
copy_mw_cel -from ${DESIGN} -to ${DESIGN}_FILL

exit
