################################################################################
# init_setup.tcl : Applies path/design definition and sets variables
################################################################################

# Path/Design definition -------------------------------------------------------
set PROJPATH                        [getenv CBD_ROOT]              
set SYNPATH                         "${PROJPATH}/Synthesis/output"    
set MODEL_PATH                      "${PROJPATH}/xmodel_dpll"               
set LOGICAL_LIB_PATH                "${PROJPATH}/ACL/logical_lib" 
set PNR_ROOT_PATH                   "${PROJPATH}/Place_Route"         
set MW_LIB_PATH                     "${PNR_ROOT_PATH}/lib"            
set TECHPATH                        "${PROJPATH}/ACL/techfile"    
set TLU+PATH                        "${PROJPATH}/ACL/tluplus"     
set SCRIPT_PATH                     "${PNR_ROOT_PATH}/script"         
set PAD_CONSTRAINTS                 "${SCRIPT_PATH}/pad_constraints"  
set RESULTS_DIR                     "${SCRIPT_PATH}/results"          
set TECH                            "scmos"
set DESIGN                          "top"                            
# ------------------------------------------------------------------------------

# Set logical_library ----------------------------------------------------------
set_app_var search_path				"${LOGICAL_LIB_PATH}"
set_app_var link_library			"* cello.slow.db harp.db viola.db"
set_app_var target_library			"cello.slow.db harp.db viola.db"
# ------------------------------------------------------------------------------

# Set tlu+ ---------------------------------------------------------------------
set_tlu_plus_files   -max_tluplus ${TLU+PATH}/scmos_65.tluplus  -min_tluplus ${TLU+PATH}/scmos_65.tluplus -tech2itf_map  ${TLU+PATH}/scmos_65_map.itf
# ------------------------------------------------------------------------------

# Defining Lambda based grid----------------------------------------------------
set LAMBDA                          0.035                
set STD_CELL_PITCH_W		    [ expr 8*$LAMBDA  ] 
set STD_CELL_PITCH_H		    [ expr 80*$LAMBDA ]
# ------------------------------------------------------------------------------

# Defining Chip & Pad size -----------------------------------------------------
set CHIP_WIDTH                      [ expr 29760*$LAMBDA ] ; #1041.6 
set CHIP_HEIGHT                     [ expr 29760*$LAMBDA ] ; #1041.6
set PAD_HEIGHT                      [ expr 5600*$LAMBDA ] ; #196
set PAD_SPACE                       [ expr 2320*$LAMBDA ] ; #81.2
set CORE_WIDTH                      [ expr $CHIP_WIDTH - 2*$PAD_HEIGHT ] ;  
set CORE_HEIGHT                     [ expr $CHIP_HEIGHT - 2*$PAD_HEIGHT ] ; 
# ------------------------------------------------------------------------------

# Information for filler insertion ---------------------------------------------
set FILLER_ARRAY                    "FILLCAP_X16 FILLCAP_X8 FILLCAP_X4 FILLCAP_X2 FILLCAP_X1 FILL_X1"  
set PAD_CORNER_CELL                 "pad_corner"

set FILLER_TOT_XS                  [ expr $PAD_HEIGHT ]  
set FILLER_TOT_YS                  [ expr $PAD_HEIGHT ]  
set FILLER_TOT_XF                  [ expr $CORE_WIDTH+$PAD_HEIGHT ]  
set FILLER_TOT_YF                  [ expr $CORE_HEIGHT+$PAD_HEIGHT ] 
set FILLER_TOT_AREA                [ list [ list $FILLER_TOT_XS $FILLER_TOT_YS ] [ list $FILLER_TOT_XF $FILLER_TOT_YF ] ] ;            # specify filler-insertion total area


set DPLL_FILLER_XS                  [ expr 7240*$LAMBDA] ; #253.4 
set DPLL_FILLER_YS                  [ expr 8480*$LAMBDA] ; #296.8  
set DPLL_FILLER_XF                  [ expr $CORE_WIDTH+$PAD_HEIGHT ]  
set DPLL_FILLER_YF                  [ expr $CORE_HEIGHT+$PAD_HEIGHT ] 
set DPLL_FILLER_AREA                [ list [ list $DPLL_FILLER_XS $DPLL_FILLER_YS ] [ list $DPLL_FILLER_XF $DPLL_FILLER_YF ] ] ;            # specify filler-insertion total area

# ------------------------------------------------------------------------------

# Power-domain/strap information -------------------------------------------
set NUM_PG                           4      
set DPLL_POWER_NET                   "vdda" 
set GROUND_NET                       "vss"  
set TEST_POWER_NET                   "vddt" 

set DPLL_ANALOG_POWER_PIN           "vdd" 
set DPLL_TEST_POWER_PIN             "vddt" 
set DPLL_GROUND_PIN                 "vss" 

set TEST_POWER_PIN                  "vddt" 
set TEST_GROUND_PIN                 "vss" 

set STD_POWER_PIN                   "VDD"  
set STD_GROUND_PIN                  "VSS"  

set POWER_STRAP_LAYER_V             "METAL6"

set POWER_STRAP_WIDTH_H               [ expr 30*$LAMBDA ]  
set POWER_STRAP_PITCH_H               [ expr 80*$LAMBDA ] 
set POWER_STRAP_WIDTH_V               [ expr 80*$LAMBDA ]  
set POWER_STRAP_PITCH_V               [ expr 160*$LAMBDA ] 

set STRAP_INCREMENT_H                 [ expr $NUM_PG*$POWER_STRAP_PITCH_H ] 
set STRAP_INCREMENT_V                 [ expr $NUM_PG*$POWER_STRAP_PITCH_V ] 

set DPLL_STRAP_START_X_H              [ expr $PAD_HEIGHT ] 
set DPLL_STRAP_START_Y_H              [ expr $PAD_HEIGHT ] 
set DPLL_STRAP_STOP_X_H               [ expr $CORE_WIDTH ]
set DPLL_STRAP_STOP_Y_H               [ expr $CORE_HEIGHT ]

set DPLL_STRAP_START_X_V              [ expr $PAD_HEIGHT+$POWER_STRAP_WIDTH_V/2] 
set DPLL_STRAP_START_Y_V              [ expr $PAD_HEIGHT ] 
set DPLL_STRAP_STOP_X_V               [ expr $CORE_WIDTH+$PAD_HEIGHT]
set DPLL_STRAP_STOP_Y_V               [ expr $CORE_HEIGHT+$PAD_HEIGHT ]
# ------------------------------------------------------------------------------

# Control inputs ---------------------------------------------------------------
set MW_TOP_EXIST                    "1" 
set ICC_SANITY_CHECK                FALSE ;	         # TRUE|FALSE, set TRUE to perform check_physical_design
set BASIC_PLACE_OPT                 TRUE  ;
set PRECLOCK_PLACE_OPT              FALSE ;
set ICC_CTS_RULE_NAME               "iccrm_clock_double_spacing" ; # specify clock routing rule name  
set ICC_CTS_LAYER_LIST              "METAL3 METAL4" ;        # clock tree layers, usually M3 and above; e.g. set ICC_CTS_LAYER_LIST "M3 M4 M5"
set ICC_CTS_INTERCLOCK_BALANCING    TRUE ;           # set TRUE to perform ICDB
set ICC_CTS_INTERCLOCK_BALANCING_OPTIONS_FILE "" ;   # set interclock_delay options
set ICC_CTS_UPDATE_LATENCY          TRUE ;           # set TRUE to perform clock latency update post CTS
set ICC_CTS_LATENCY_OPTIONS_FILE    ""   ;           # define here the latency adjustment options options
set ICC_FIX_HOLD_PREFER_CELLS       "cello.slow/INV_X2"  ;  # Syntax: library/cell_name - Example: slow/DLY1X1 slow/DLY1X4
set ICC_POST_CLOCK_ROUTE_CTO        TRUE ;                  # set TRUE if you want to run Post route CTO after clock routing
set ICC_DBL_VIA                     TRUE ;                  # TRUE|FALSE; set to TRUE to enable detail route wire spreading
set ICC_FIX_ANTENNA                 TRUE ;                  # TRUE|FALSE: set to TRUE to enable antenna fixing
#set ICC_ROUTING_DIODES				"ANTENNA1_A9TL" ;       # space separated list of diode names
set ICC_CTS_RULE_NAME               "iccrm_clock_double_spacing" ;  # specify clock routing rule name 
set CRITICAL_PATH_ZRT               FALSE   ;   # Route critical path using ZROUTE
set ICC_NUM_CPUS                    2      ;
set MIM_FLOW                        "FALSE"	;
set ICC_REDUCE_CRITICAL_AREA        TRUE    ;   # TRUE|FALSE; set to TRUE to enable detail route wire spreading
set TIMING_PRESERVE_SLACK_SETUP     "0.1"   ;	# float : setup slack threshold for wire_spreading/widening/timing driven ICV metal fill; default 0.1
set TIMING_PRESERVE_SLACK_HOLD      "0"     ;	# float : hold slack threshold for wire_spreading/widening; default 0
set MAX_FANOUT                      "100"   ;   # set fanout-limitation through overall design
set PLACE_EFFORT                    "medium";
set ROUTE_EFFORT                    "high"  ;
# ------------------------------------------------------------------------------

# Open Milkyway-based physical library -----------------------------------------
open_mw_lib ${MW_LIB_PATH}/${DESIGN}/
# ------------------------------------------------------------------------------
