################################################################################
# init_design.tcl : initial script which reads the design and makes floorplan 
################################################################################

source -echo ./icc_scripts/init_setup.tcl

# Read hirarachical design -----------------------------------------------------
read_verilog -top top -verbose "                            \
$PNR_ROOT_PATH/script/x2syn.h                           \
$SYNPATH/digital_lf/digital_lf_mapped.v \
$MODEL_PATH/dpll/dpll.sv \
$MODEL_PATH/top/top.sv \
"
# ------------------------------------------------------------------------------

# Setting user grid for placement of custom-cells & io-cells -------------------
set_user_grid -x_step ${STD_CELL_PITCH_W} -y_step ${STD_CELL_PITCH_H}
set_object_snap_type -class standard_cell -snap user
set_object_snap_type -class soft_macro -snap user
set_object_snap_type -class hard_macro -snap user
set_object_snap_type -class plan_group -snap user
# ------------------------------------------------------------------------------
# PAD assignment
set_pad_physical_constraints -chip_level_distance {\
    {dist_left_edge_to_pad   0}\
    {dist_right_edge_to_pad  0}\
    {dist_bottom_edge_to_pad 0}\
    {dist_top_edge_to_pad    0}\
    }

source ${PAD_CONSTRAINTS}/corner.tcl
source ${PAD_CONSTRAINTS}/bottom.tcl
source ${PAD_CONSTRAINTS}/left.tcl
source ${PAD_CONSTRAINTS}/right.tcl
source ${PAD_CONSTRAINTS}/top.tcl

# Creation of floorplan
create_floorplan -control_type width_and_height -core_width $CORE_WIDTH -core_height $CORE_HEIGHT -left_io2core 0 -bottom_io2core 0 -right_io2core 0 -top_io2core 0

# Setting preferred routing direction
remove_preferred_routing_direction -layers {METAL1 METAL2 METAL3 METAL4 METAL5 METAL6 METALTOP}
set_preferred_routing_direction -layers {METAL1 METAL3 METAL5 METALTOP} -direction vertical
set_preferred_routing_direction -layers {METAL2 METAL4 METAL6} -direction horizontal

# Creation & visualization of plan groups
remove_plan_groups -all

create_plan_groups {dpll0/digital_lf} -cycle_color

# Coarse Placement & resizing of plan groups
create_fp_placement
shape_fp_blocks
create_fp_placement
# ------------------------------------------------------------------------------
# Reading SDC-format timing-constraint for each cell ---------------------------

## dpll
current_instance /top/dpll0/digital_lf
read_sdc ${SYNPATH}/digital_lf/digital_lf_mapped.cell.sdc

current_instance 
# ------------------------------------------------------------------------------
#create_fp_placement

save_mw_cel ${DESIGN}
copy_mw_cel -from ${DESIGN} -to ${DESIGN}_INIT

exit
