################################################################################
# clock_tree_syn.tcl : CTS script performs synthesis, routing of clock nets, extraction, optimization, and timing-violation fixing on the design.
################################################################################

source -echo ./icc_scripts/init_setup.tcl
open_mw_cel ${DESIGN}

# Initialization of CTS rule ---------------------------------------------------
redirect -var x {report_routing_rules $ICC_CTS_RULE_NAME}
if {$ICC_CTS_RULE_NAME == "iccrm_clock_double_spacing" && [regexp "Info: No nondrule" $x]} {
  define_routing_rule iccrm_clock_double_spacing -default_reference_rule -multiplier_spacing 2
  ## add -multiplier_width 2 for double width
  report_routing_rule iccrm_clock_double_spacing
  set_clock_tree_options -routing_rule iccrm_clock_double_spacing -use_default_routing_for_sinks 1
}
# ------------------------------------------------------------------------------

# Specifies CTS constraints and options for clocks in the design ---------------
if {$ICC_CTS_LAYER_LIST != ""} {set_clock_tree_options -layer_list $ICC_CTS_LAYER_LIST}
set_clock_tree_options -logic_level_balance true
set_clock_tree_options -buffer_sizing true -buffer_relocation true
set_clock_tree_options -insert_boundary_cell false
set_clock_tree_options -max_fanout $MAX_FANOUT
# ------------------------------------------------------------------------------

# Removal ideal network for CTS (exception : reset signals in the design) ------
remove_ideal_network [all_fanout -flat -clock_tree]
set_ideal_network [get_ports reset_n]
# ------------------------------------------------------------------------------

# set fix hold-time violations in all clock networks ---------------------------
set_fix_hold [all_clocks]
# ------------------------------------------------------------------------------

# 1. clock tree synthesis
set clock_opt_cts_cmd "clock_opt -fix_hold_all_clocks -no_clock_route"
if {$ICC_CTS_INTERCLOCK_BALANCING && [file exists [which $ICC_CTS_INTERCLOCK_BALANCING_OPTIONS_FILE]]} {lappend clock_opt_cts_cmd -inter_clock_balance}
if {$ICC_CTS_UPDATE_LATENCY} {lappend clock_opt_cts_cmd -update_clock_latency}
#if {[file exists [which $ICC_CTS_SELF_GATING_SAIF_FILE]]} {lappend clock_opt_cts_cmd -insert_self_gating}
echo $clock_opt_cts_cmd
eval $clock_opt_cts_cmd

## Hold fixing cells
if { $ICC_FIX_HOLD_PREFER_CELLS != ""} {
    remove_attribute [get_lib_cells $ICC_FIX_HOLD_PREFER_CELLS] dont_touch
    set_prefer -min [get_lib_cells $ICC_FIX_HOLD_PREFER_CELLS]
    set_fix_hold_options -preferred_buffer
}

# 2. Post CTS optimization

# clock_opt PSYN
set clock_opt_psyn_cmd "clock_opt -no_clock_route -only_psyn"
echo $clock_opt_psyn_cmd
eval $clock_opt_psyn_cmd

remove_route_by_type -clock_ring -clock_strap -clock_tie_off -clock_user
# ------------------------------------------------------------------------------

save_mw_cel ${DESIGN}
copy_mw_cel -from ${DESIGN} -to ${DESIGN}_CTS

exit
