################################################################################
# route_optimizer.tcl : route_optimizer performs simultaneous routing and postrouting optimization on the design
################################################################################

source -echo ./icc_scripts/init_setup.tcl
open_mw_cel ${DESIGN}

remove_preferred_routing_direction -layers {METAL1 METAL2 METAL3 METAL4 METAL5 METAL6 METALTOP}
set_preferred_routing_direction -layers {METAL1 METAL3 METAL5 METALTOP} -direction vertical
set_preferred_routing_direction -layers {METAL4 METAL6} -direction horizontal

# Routing option ---------------------------------------------------------------

set_route_zrt_common_options  -read_user_metal_blockage_layer true -wide_macro_pin_as_fat_wire true
set_route_zrt_detail_options  -check_pin_min_area_min_length true -use_default_width_for_min_area_min_len_stub true
set_route_zrt_common_options -connect_within_pins {{METAL1 via_all_pins} }
set_route_zrt_common_options -connect_within_pins {{METAL2 via_all_pins} }
set_route_zrt_common_options -connect_within_pins {{METAL3 via_all_pins} }
set_route_zrt_common_options -connect_within_pins {{METAL4 via_all_pins} }
set_route_zrt_common_options -connect_within_pins {{METAL5 via_all_pins} }
set_route_zrt_common_options -connect_within_pins {{METAL6 via_all_pins} }
set_route_zrt_common_options -connect_within_pins {{METALTOP via_all_pins} }
set_route_zrt_common_options -wide_macro_pin_as_fat_wire true
# ------------------------------------------------------------------------------

# Antenna rules ----------------------------------------------------------------

#source -echo $ANTENNA_RULES_FILE

set_route_zrt_detail_options\
    -antenna true\
    -antenna_fixing_preference hop_layers\
    -antenna_on_iteration 1\
    -antenna_verbose_level 2\
    -diode_insertion_mode new_and_spare\
    -default_diode_protection 10000\
    -default_gate_size 0.0024\
    -insert_diodes_during_routing false\
    -default_port_external_gate_size 0.0024\
    -default_port_external_antenna_area 0.0\
    -reuse_filler_locations_for_diodes true\
    -generate_extra_off_grid_pin_tracks true
# ------------------------------------------------------------------------------

# Caution : you have to execute critical path routing before running route_optimizer.tcl

# 3. Clock tree routing --------------------------------------------------------

route_group -all_clock_nets -no_track -no_detail
# Turning off SI for clock routing
set_si_options -delta_delay false -min_delta_delay false -route_xtalk_prevention false
route_group -all_clock_nets -search_repair_loop 20
if {$ICC_POST_CLOCK_ROUTE_CTO} { \
optimize_clock_tree -routed_clock_stage detail \
}
# ------------------------------------------------------------------------------

   #############
   # route_opt #
   #############
# ------------------------------------------------------------------------------

# Pre route_opt checks
# Check for Ideal Nets
set num_ideal [sizeof_collection [all_ideal_nets]]
if {$num_ideal >= 1} {echo "SCRIPT-Error-Info: $num_ideal Nets are ideal prior to route_opt. Please investigate."}
# Check for HFNs (high fanout nets)
set hfn_thres "41 101 501"
foreach thres $hfn_thres {
  set num_hfn [sizeof_collection [all_high_fanout -nets -threshold $thres]]
  echo "SCRIPT-Info: Number of nets with fanout > $thres = $num_hfn"
  if {$thres == 501 && $num_hfn >=1} {
    echo "SCRIPT-Error-Info: $num_hfn Nets with fanout > 500 exist prior to route_opt - Please check if marked ideal - possibly add buffer tree"
  }
}

# Initial routing
route_opt -initial_route_only

if {$ICC_CTS_UPDATE_LATENCY} {
   update_clock_latency
}

if {$ICC_DBL_VIA} {
## To get optimal double via rate, perform first a non-timing driven double via insertion.
## Auto mode for insert_redundant_via
  insert_zrt_redundant_vias -effort high
  insert_zrt_redundant_vias -auto_mode insert -num_cpus $ICC_NUM_CPUS
}

set route_opt_cmd "route_opt -skip_initial_route -effort high "
echo $route_opt_cmd
eval $route_opt_cmd

save_mw_cel ${DESIGN}
copy_mw_cel -from ${DESIGN} -to ${DESIGN}_ROUTE

exit
