################################################################################
# place_optimizer.tcl : place-optimizer script places all the cells of the top level and also fix the relative placement cells in the specified placement groups
################################################################################

source -echo ./icc_scripts/init_setup.tcl
open_mw_cel ${DESIGN}

# Setting user grid for placement of custom-cells $ io-cells -------------------
set_user_grid -x_step ${STD_CELL_PITCH_W} -y_step ${STD_CELL_PITCH_H}
set_object_snap_type -class standard_cell -snap user
set_object_snap_type -class soft_macro -snap user
set_object_snap_type -class hard_macro -snap user
set_object_snap_type -class plan_group -snap user
# ------------------------------------------------------------------------------

# Custom-cells/plan-group placement --------------------------------------------

# Analog cells & Plangroups
source -echo ${SCRIPT_PATH}/floorplan/${DESIGN}.tcl

# ------------------------------------------------------------------------------
## Uncertainty handling pre-cts
set_ideal_network [all_fanout -flat -clock_tree ]

# To validate the physical data in design before placement ---------------------
if {$ICC_SANITY_CHECK} {                      
    check_physical_design -stage pre_place_opt
}

if {$BASIC_PLACE_OPT} {
# Before running high-fanout synthesis during the place_opt step, define the buffering options by using below constraint 
set_ahfs_options -default

#set_dont_touch [get_nets tesTx/vbias_cml] true
place_opt -effort $PLACE_EFFORT 
}                         
# 2. CTS during place_opt
if {$PRECLOCK_PLACE_OPT} {
place_opt -cts -effort medium
}
# ------------------------------------------------------------------------------

save_mw_cel $DESIGN
copy_mw_cel -from ${DESIGN} -to ${DESIGN}_PLACE

exit
