################################################################################
# output.tcl : Generates output files including DRC&LVS results/GDS/sdf-constraints/rc-extraction
################################################################################

source -echo ./icc_scripts/init_setup.tcl
open_mw_cel ${DESIGN}

## DRC verification (Hercules) --------------------------------------------------
verify_drc -check_via_size -check_enclosure -check_end_of_line -check_via_farm -check_fat_poly_contact -check_blockage >> drc_hercules.log
## ------------------------------------------------------------------------------
#
## LVS verification (Hercules) --------------------------------------------------
verify_lvs -max_error 100000 -use_notch_gap_fill_cell -check_single_pin_net_for_floating_port -check_single_pin_net_for_floating_net -check_floating_port_on_null_net -check_open_locator -check_short_locator >> lvs_hercules.log
## ------------------------------------------------------------------------------
# Post-verilog netlist ---------------------------------------------------------
# For LVS use,the option -no_physical_only_cells is removed
## To make case insensitive, use this command.
define_name_rules -case_insensitive case_rule
change_names -rules case_rule -hierarchy

write_verilog -pg -wire_declaration $RESULTS_DIR/$DESIGN.output.pg.lvs.v
# ------------------------------------------------------------------------------

# SDC --------------------------------------------------------------------------
set_app_var write_sdc_output_lumped_net_capacitance false
set_app_var write_sdc_output_net_resistance false
write_sdc $RESULTS_DIR/$DESIGN.output.sdc
# ------------------------------------------------------------------------------

# SDF --------------------------------------------------------------------------
write_sdf -version 2.1 $RESULTS_DIR/$DESIGN.output.sdf
extract_rc -coupling_cap
write_parasitics  -format SPEF -output $RESULTS_DIR/$DESIGN.output.spef -no_name_mapping
# ------------------------------------------------------------------------------

# DEF --------------------------------------------------------------------------
write_def -output  $RESULTS_DIR/$DESIGN.output.def

# GDS stream out ---------------------------------------------------------------
set_write_stream_options \
    -child_depth 99 \
    -output_pin {text geometry} \
    -keep_data_type \

write_stream -format gds -cells {top.CEL;1} $RESULTS_DIR/${DESIGN}.gds
# ------------------------------------------------------------------------------

save_mw_cel ${DESIGN}
copy_mw_cel -from ${DESIGN} -to ${DESIGN}_FIN

exit
