Technology	{
		name				= "scmos"
		date				= "April 24 2016"
		unitTimeName			= "ns"
		timePrecision			= 1000
		unitLengthName			= "micron"
		lengthPrecision			= 10000
		gridResolution			= 5
		unitVoltageName			= "v"
		voltagePrecision		= 100000
		unitCurrentName			= "mA"
		currentPrecision		= 100
		unitPowerName			= "mw"
		powerPrecision			= 1000
		unitResistanceName		= "ohm"
		resistancePrecision		= 10000000
		unitCapacitanceName		= "pf"
		capacitancePrecision		= 10000000
		unitInductanceName		= "nh"
		inductancePrecision		= 100
		minBaselineTemperature		= 25
		nomBaselineTemperature		= 25
		maxBaselineTemperature		= 25
		fatWireExtensionMode		= 1
		minEdgeMode			= 1
		stubMode			= 4
                maxStackLevelMode               = 2
                cornerSpacingMode               = 1
}

Tile		"unit" {
		width				= 0.28
		height				= 2.8
}

Layer		"METAL1" {
		layerNumber			= 31
		maskName			= "metal1"
		isDefaultLayer			= 1
		visible				= 1
		selectable			= 1
		blink				= 0
		color				= "cyan"
		lineStyle			= "solid"
		pattern				= "dot"
		pitch				= 0.28
		defaultWidth			= 0.14
		minWidth			= 0.105
		minSpacing			= 0.105
		maxWidth			= 12
		stubSpacing			= 0.14
		stubThreshold			= 0.14
		endOfLineCornerKeepoutWidth	= 0.035
		fatTblDimension			= 5
		fatTblThreshold			= (0,0.21,0.42,1.54,4.55)
		fatTblParallelLength		= (0,0.385,0.42,1.54,4.55)
		fatTblSpacing			= (0.105,0.14,0.175,0.525,1.54,
						   0.14,0.14,0.175,0.525,1.54,
						   0.175,0.175,0.175,0.525,1.54,
						   0.525,0.525,0.525,0.525,1.54,
						   1.54,1.54,1.54,1.54,1.54)
		minArea				= 0.0441
		minEnclosedArea			= 0.2009
		maxNumMinEdge			= 1
		minEdgeLength			= 0.09
}

Layer		"METAL2" {
		layerNumber			= 32
		maskName			= "metal2"
		isDefaultLayer			= 1
		visible				= 1
		selectable			= 1
		blink				= 0
		color				= "yellow"
		lineStyle			= "solid"
		pattern				= "blank"
		pitch				= 0.28
		defaultWidth			= 0.14
		minWidth			= 0.105
		minSpacing			= 0.105
		maxWidth			= 12
		stubSpacing			= 0.14
		stubThreshold			= 0.14
		endOfLineCornerKeepoutWidth	= 0.035
		fatTblDimension			= 5
		fatTblThreshold			= (0,0.21,0.42,1.54,4.55)
		fatTblParallelLength		= (0,0.385,0.42,1.54,4.55)
		fatTblSpacing			= (0.105,0.14,0.175,0.525,1.54,
						   0.14,0.14,0.175,0.525,1.54,
						   0.175,0.175,0.175,0.525,1.54,
						   0.525,0.525,0.525,0.525,1.54,
						   1.54,1.54,1.54,1.54,1.54)
		minArea				= 0.0539
		minEnclosedArea			= 0.2009
		maxNumMinEdge			= 1
		minEdgeLength			= 0.1
}

Layer		"METAL3" {
		layerNumber			= 33
		maskName			= "metal3"
		isDefaultLayer			= 1
		visible				= 1
		selectable			= 1
		blink				= 0
		color				= "red"
		lineStyle			= "solid"
		pattern				= "blank"
		pitch				= 0.28
		defaultWidth			= 0.14
		minWidth			= 0.14
		minSpacing			= 0.14
		maxWidth			= 12
		stubSpacing			= 0.14
		stubThreshold			= 0.14
		endOfLineCornerKeepoutWidth	= 0.035
		fatTblDimension			= 5
		fatTblThreshold			= (0,0.21,0.42,1.54,4.55)
		fatTblParallelLength		= (0,0.385,0.42,1.54,4.55)
		fatTblSpacing			= (0.14,0.14,0.175,0.525,1.54,
						   0.14,0.14,0.175,0.525,1.54,
						   0.175,0.175,0.175,0.525,1.54,
						   0.525,0.525,0.525,0.525,1.54,
						   1.54,1.54,1.54,1.54,1.54)
		minArea				= 0.0539
		minEnclosedArea			= 0.2009
		maxNumMinEdge			= 1
		minEdgeLength			= 0.14
}

Layer		"METAL4" {
		layerNumber			= 34
		maskName			= "metal4"
		isDefaultLayer			= 1
		visible				= 1
		selectable			= 1
		blink				= 0
		color				= "green"
		lineStyle			= "solid"
		pattern				= "blank"
		pitch				= 0.28
		defaultWidth			= 0.14
		minWidth			= 0.14
		minSpacing			= 0.14
		maxWidth			= 12
		stubSpacing			= 0.14
		stubThreshold			= 0.14
		endOfLineCornerKeepoutWidth	= 0.035
		fatTblDimension			= 5
		fatTblThreshold			= (0,0.21,0.42,1.54,4.55)
		fatTblParallelLength		= (0,0.385,0.42,1.54,4.55)
		fatTblSpacing			= (0.14,0.14,0.175,0.525,1.54,
						   0.14,0.14,0.175,0.525,1.54,
						   0.175,0.175,0.175,0.525,1.54,
						   0.525,0.525,0.525,0.525,1.54,
						   1.54,1.54,1.54,1.54,1.54)
		minArea				= 0.052
		minEnclosedArea			= 0.2
		maxNumMinEdge			= 1
		minEdgeLength			= 0.1
}

Layer		"METAL5" {
		layerNumber			= 35
		maskName			= "metal5"
		isDefaultLayer			= 1
		visible				= 1
		selectable			= 1
		blink				= 0
		color				= "magenta"
		lineStyle			= "solid"
		pattern				= "blank"
		pitch				= 0.28
		defaultWidth			= 0.14
		minWidth			= 0.14
		minSpacing			= 0.14
		maxWidth			= 12
		stubSpacing			= 0.14
		stubThreshold			= 0.14
		endOfLineCornerKeepoutWidth	= 0.035
		fatTblDimension			= 5
		fatTblThreshold			= (0,0.21,0.42,1.54,4.55)
		fatTblParallelLength		= (0,0.385,0.42,1.54,4.55)
		fatTblSpacing			= (0.14,0.14,0.175,0.525,1.54,
						   0.14,0.14,0.175,0.525,1.54,
						   0.175,0.175,0.175,0.525,1.54,
						   0.525,0.525,0.525,0.525,1.54,
						   1.54,1.54,1.54,1.54,1.54)
		minArea				= 0.0539
		minEnclosedArea			= 0.2009
		maxNumMinEdge			= 1
		minEdgeLength			= 0.1
}

Layer		"METAL6" {
		layerNumber			= 36
		maskName			= "metal6"
		isDefaultLayer			= 1
		visible				= 1
		selectable			= 1
		blink				= 0
		color				= "orange"
		lineStyle			= "dot"
		pattern				= "backSlash"
		pitch				= 0.28
		defaultWidth			= 0.14
		minWidth			= 0.14
		minSpacing			= 0.14
		maxWidth			= 12
		stubSpacing			= 0.14
		stubThreshold			= 0.14
		endOfLineCornerKeepoutWidth	= 0.035
		fatTblDimension			= 5
		fatTblThreshold			= (0,0.21,0.42,1.54,4.55)
		fatTblParallelLength		= (0,0.385,0.42,1.54,4.55)
		fatTblSpacing			= (0.14,0.14,0.175,0.525,1.54,
						   0.14,0.14,0.175,0.525,1.54,
						   0.175,0.175,0.175,0.525,1.54,
						   0.525,0.525,0.525,0.525,1.54,
						   1.54,1.54,1.54,1.54,1.54)
		minArea				= 0.0539
		minEnclosedArea			= 0.2009
		maxNumMinEdge			= 1
		minEdgeLength			= 0.14
}

Layer           "METALTOP" {
                layerNumber                     = 74
                maskName                        = "metal7"
                isDefaultLayer                  = 1
                visible                         = 1
                selectable                      = 1
                blink                           = 0
                color                           = "59"
                lineStyle                       = "solid"
                pattern                         = "slash"
                pitch                           = 6.5
                defaultWidth                    = 3
                minWidth                        = 3
                minArea                         = 0.1
                minSpacing                      = 2
                maxWidth                        = 100
}

Layer		"VIA1" {
		layerNumber			= 51
		maskName			= "via1"
		isDefaultLayer			= 1
		visible				= 1
		selectable			= 1
		blink				= 0
		color				= "43"
		lineStyle			= "solid"
		pattern				= "rectangleX"
		pitch				= 0
		defaultWidth			= 0.1
		minWidth			= 0.1
		minSpacing			= 0.13
		cornerMinSpacing		= 0.1
		sameNetMinSpacing		= 0.1
		maxStackLevel			= 6
		fatTblDimension			= 5
		fatTblThreshold			= (0,0.301,0.701,2.001,3.001)
		fatTblExtensionRange		= (0,0.8,0.8,2,5)
		fatTblFatContactNumber		= (2,2,10,10,10)
		fatTblFatContactMinCuts		= (1,2,4,4,4)
		fatTblExtensionContactNumber	= (2,2,10,10,10)
		fatTblExtensionMinCuts		= (1,2,2,2,2)
		enclosedCutNumNeighbor		= 3
		enclosedCutNeighborRange	= 0.14
		enclosedCutToNeighborMinSpacing	= 0.13
}

Layer		"VIA2" {
		layerNumber			= 52
		maskName			= "via2"
		isDefaultLayer			= 1
		visible				= 1
		selectable			= 1
		blink				= 0
		color				= "blue"
		lineStyle			= "solid"
		pattern				= "rectangleX"
		pitch				= 0
		defaultWidth			= 0.1
		minWidth			= 0.1
		minSpacing			= 0.13
		cornerMinSpacing		= 0.1
		sameNetMinSpacing		= 0.1
		maxStackLevel			= 6
		fatTblDimension			= 5
		fatTblThreshold			= (0,0.301,0.701,2.001,3.001)
		fatTblExtensionRange		= (0,0.8,0.8,2,5)
		fatTblFatContactNumber		= (3,3,11,11,11)
		fatTblFatContactMinCuts		= (1,2,4,4,4)
		fatTblExtensionContactNumber	= (3,3,11,11,11)
		fatTblExtensionMinCuts		= (1,2,2,2,2)
		enclosedCutNumNeighbor		= 3
		enclosedCutNeighborRange	= 0.14
		enclosedCutToNeighborMinSpacing	= 0.13
}

Layer		"VIA3" {
		layerNumber			= 53
		maskName			= "via3"
		isDefaultLayer			= 1
		visible				= 1
		selectable			= 1
		blink				= 0
		color				= "yellow"
		lineStyle			= "solid"
		pattern				= "rectangleX"
		pitch				= 0
		defaultWidth			= 0.1
		minWidth			= 0.1
		minSpacing			= 0.13
		cornerMinSpacing		= 0.1
		sameNetMinSpacing		= 0.1
		fatTblDimension			= 5
		fatTblThreshold			= (0,0.301,0.701,2.001,3.001)
		fatTblExtensionRange		= (0,0.8,0.8,2,5)
		fatTblFatContactNumber		= (4,4,12,12,12)
		fatTblFatContactMinCuts		= (1,2,4,4,4)
		fatTblExtensionContactNumber	= (4,4,12,12,12)
		fatTblExtensionMinCuts		= (1,2,2,2,2)
		enclosedCutNumNeighbor		= 3
		enclosedCutNeighborRange	= 0.14
		enclosedCutToNeighborMinSpacing	= 0.13
}

Layer		"VIA4" {
		layerNumber			= 54
		maskName			= "via4"
		isDefaultLayer			= 1
		visible				= 1
		selectable			= 1
		blink				= 0
		color				= "white"
		lineStyle			= "solid"
		pattern				= "rectangleX"
		pitch				= 0
		defaultWidth			= 0.1
		minWidth			= 0.1
		minSpacing			= 0.13
		cornerMinSpacing		= 0.1
		sameNetMinSpacing		= 0.1
		fatTblDimension			= 5
		fatTblThreshold			= (0,0.301,0.701,2.001,3.001)
		fatTblExtensionRange		= (0,0.8,0.8,2,5)
		fatTblFatContactNumber		= (5,5,13,13,13)
		fatTblFatContactMinCuts		= (1,2,4,4,4)
		fatTblExtensionContactNumber	= (5,5,13,13,13)
		fatTblExtensionMinCuts		= (1,2,2,2,2)
		enclosedCutNumNeighbor		= 3
		enclosedCutNeighborRange	= 0.14
		enclosedCutToNeighborMinSpacing	= 0.13
}

Layer		"VIA5" {
		layerNumber			= 55
		maskName			= "via5"
		isDefaultLayer			= 1
		visible				= 1
		selectable			= 1
		blink				= 0
		color				= "27"
		lineStyle			= "solid"
		pattern				= "rectangleX"
		pitch				= 0
		defaultWidth			= 0.1
		minWidth			= 0.1
		minSpacing			= 0.13
		cornerMinSpacing		= 0.1
		sameNetMinSpacing		= 0.1
		fatTblDimension			= 5
		fatTblThreshold			= (0,0.301,0.701,2.001,3.001)
		fatTblExtensionRange		= (0,0.8,0.8,2,5)
		fatTblFatContactNumber		= (6,6,14,14,14)
		fatTblFatContactMinCuts		= (1,2,4,4,4)
		fatTblExtensionContactNumber	= (6,6,14,14,14)
		fatTblExtensionMinCuts		= (1,2,2,2,2)
		enclosedCutNumNeighbor		= 3
		enclosedCutNeighborRange	= 0.14
		enclosedCutToNeighborMinSpacing	= 0.13
}

Layer           "VIA6" {
                layerNumber                     = 85
                maskName                        = "via6"
                isDefaultLayer                  = 1
                visible                         = 1
                selectable                      = 1
                blink                           = 0
                color                           = "green"
                lineStyle                       = "solid"
                pattern                         = "rectangleX"
                pitch                           = 0
                defaultWidth                    = 3
                minWidth                        = 3
                minSpacing                      = 2
}


ContactCode	"VIA12" {
		contactCodeNumber		= 2
		cutLayer			= "VIA1"
		lowerLayer			= "METAL1"
		upperLayer			= "METAL2"
		isDefaultContact		= 1
		cutWidth			= 0.1
		cutHeight			= 0.1
		upperLayerEncWidth		= 0.02
		upperLayerEncHeight		= 0.02
		lowerLayerEncWidth		= 0.02
		lowerLayerEncHeight		= 0.02
		minCutSpacing			= 0.1
}

ContactCode	"VIA23" {
		contactCodeNumber		= 3
		cutLayer			= "VIA2"
		lowerLayer			= "METAL2"
		upperLayer			= "METAL3"
		isDefaultContact		= 1
		cutWidth			= 0.1
		cutHeight			= 0.1
		upperLayerEncWidth		= 0.02
		upperLayerEncHeight		= 0.02
		lowerLayerEncWidth		= 0.02
		lowerLayerEncHeight		= 0.02
		minCutSpacing			= 0.1
}

ContactCode	"VIA34" {
		contactCodeNumber		= 4
		cutLayer			= "VIA3"
		lowerLayer			= "METAL3"
		upperLayer			= "METAL4"
		isDefaultContact		= 1
		cutWidth			= 0.1
		cutHeight			= 0.1
		upperLayerEncWidth		= 0.02
		upperLayerEncHeight		= 0.02
		lowerLayerEncWidth		= 0.02
		lowerLayerEncHeight		= 0.02
		minCutSpacing			= 0.1
}

ContactCode	"VIA45" {
		contactCodeNumber		= 5
		cutLayer			= "VIA4"
		lowerLayer			= "METAL4"
		upperLayer			= "METAL5"
		isDefaultContact		= 1
		cutWidth			= 0.1
		cutHeight			= 0.1
		upperLayerEncWidth		= 0.02
		upperLayerEncHeight		= 0.02
		lowerLayerEncWidth		= 0.02
		lowerLayerEncHeight		= 0.02
		minCutSpacing			= 0.1
}

ContactCode	"VIA56" {
		contactCodeNumber		= 6
		cutLayer			= "VIA5"
		lowerLayer			= "METAL5"
		upperLayer			= "METAL6"
		isDefaultContact		= 1
		cutWidth			= 0.1
		cutHeight			= 0.1
		upperLayerEncWidth		= 0.02
		upperLayerEncHeight		= 0.02
		lowerLayerEncWidth		= 0.02
		lowerLayerEncHeight		= 0.02
		minCutSpacing			= 0.1
}

ContactCode     "VIA67" {
                contactCodeNumber               = 34
                cutLayer                        = "VIA6"
                lowerLayer                      = "METAL6"
                upperLayer                      = "METALTOP"
                isDefaultContact                = 1
                cutWidth                        = 3
                cutHeight                       = 3
                upperLayerEncWidth              = 1.5
                upperLayerEncHeight             = 1.5
                lowerLayerEncWidth              = 1.5
                lowerLayerEncHeight             = 1.5
                minCutSpacing                   = 3
}


ContactCode	"FATVIA12" {
		contactCodeNumber		= 10
		cutLayer			= "VIA1"
		lowerLayer			= "METAL1"
		upperLayer			= "METAL2"
		isFatContact			= 1
		cutWidth			= 0.1
		cutHeight			= 0.1
		upperLayerEncWidth		= 0.02
		upperLayerEncHeight		= 0.02
		lowerLayerEncWidth		= 0.02
		lowerLayerEncHeight		= 0.02
		minCutSpacing			= 0.13
		maxNumRowsNonTurning		= 3
}

ContactCode	"FATVIA23" {
		contactCodeNumber		= 11
		cutLayer			= "VIA2"
		lowerLayer			= "METAL2"
		upperLayer			= "METAL3"
		isFatContact			= 1
		cutWidth			= 0.1
		cutHeight			= 0.1
		upperLayerEncWidth		= 0.02
		upperLayerEncHeight		= 0.02
		lowerLayerEncWidth		= 0.02
		lowerLayerEncHeight		= 0.02
		minCutSpacing			= 0.13
		maxNumRowsNonTurning		= 3
}

ContactCode	"FATVIA34" {
		contactCodeNumber		= 12
		cutLayer			= "VIA3"
		lowerLayer			= "METAL3"
		upperLayer			= "METAL4"
		isFatContact			= 1
		cutWidth			= 0.1
		cutHeight			= 0.1
		upperLayerEncWidth		= 0.02
		upperLayerEncHeight		= 0.02
		lowerLayerEncWidth		= 0.02
		lowerLayerEncHeight		= 0.02
		minCutSpacing			= 0.13
		maxNumRowsNonTurning		= 3
}

ContactCode	"FATVIA45" {
		contactCodeNumber		= 13
		cutLayer			= "VIA4"
		lowerLayer			= "METAL4"
		upperLayer			= "METAL5"
		isFatContact			= 1
		cutWidth			= 0.1
		cutHeight			= 0.1
		upperLayerEncWidth		= 0.02
		upperLayerEncHeight		= 0.02
		lowerLayerEncWidth		= 0.02
		lowerLayerEncHeight		= 0.02
		minCutSpacing			= 0.13
		maxNumRowsNonTurning		= 3
}

ContactCode	"FATVIA56" {
		contactCodeNumber		= 14
		cutLayer			= "VIA5"
		lowerLayer			= "METAL5"
		upperLayer			= "METAL6"
		isFatContact			= 1
		cutWidth			= 0.1
		cutHeight			= 0.1
		upperLayerEncWidth		= 0.02
		upperLayerEncHeight		= 0.02
		lowerLayerEncWidth		= 0.02
		lowerLayerEncHeight		= 0.02
		minCutSpacing			= 0.13
		maxNumRowsNonTurning		= 3
}

ContactCode	"VIA12_V" {
		contactCodeNumber		= 18
		cutLayer			= "VIA1"
		lowerLayer			= "METAL1"
		upperLayer			= "METAL2"
		cutWidth			= 0.1
		cutHeight			= 0.1
		upperLayerEncWidth		= 0.02
		upperLayerEncHeight		= 0.0375
		lowerLayerEncWidth		= 0.02
		lowerLayerEncHeight		= 0.0375
		minCutSpacing			= 0.1
}

ContactCode	"VIA23_V" {
		contactCodeNumber		= 19
		cutLayer			= "VIA2"
		lowerLayer			= "METAL2"
		upperLayer			= "METAL3"
		cutWidth			= 0.1
		cutHeight			= 0.1
		upperLayerEncWidth		= 0.0375
		upperLayerEncHeight		= 0.02
		lowerLayerEncWidth		= 0.02
		lowerLayerEncHeight		= 0.0375
		minCutSpacing			= 0.10
}

ContactCode	"VIA34_V" {
		contactCodeNumber		= 20
		cutLayer			= "VIA3"
		lowerLayer			= "METAL3"
		upperLayer			= "METAL4"
		cutWidth			= 0.1
		cutHeight			= 0.1
		upperLayerEncWidth		= 0.02
		upperLayerEncHeight		= 0.0375
		lowerLayerEncWidth		= 0.0375
		lowerLayerEncHeight		= 0.02
		minCutSpacing			= 0.10
}

ContactCode	"VIA45_V" {
		contactCodeNumber		= 21
		cutLayer			= "VIA4"
		lowerLayer			= "METAL4"
		upperLayer			= "METAL5"
		cutWidth			= 0.1
		cutHeight			= 0.1
		upperLayerEncWidth		= 0.0375
		upperLayerEncHeight		= 0.02
		lowerLayerEncWidth		= 0.02
		lowerLayerEncHeight		= 0.0375
		minCutSpacing			= 0.10
}

ContactCode	"VIA56_V" {
		contactCodeNumber		= 22
		cutLayer			= "VIA5"
		lowerLayer			= "METAL5"
		upperLayer			= "METAL6"
		cutWidth			= 0.1
		cutHeight			= 0.1
		upperLayerEncWidth		= 0.02
		upperLayerEncHeight		= 0.0375
		lowerLayerEncWidth		= 0.0375
		lowerLayerEncHeight		= 0.02
		minCutSpacing			= 0.10
}

DesignRule	{
		layer1				= "via1Blockage"
		layer2				= "VIA1"
		minSpacing			= 0.10
}

DesignRule	{
		layer1				= "via2Blockage"
		layer2				= "VIA2"
		minSpacing			= 0.10
}

DesignRule	{
		layer1				= "via3Blockage"
		layer2				= "VIA3"
		minSpacing			= 0.10
}

DesignRule	{
		layer1				= "via4Blockage"
		layer2				= "VIA4"
		minSpacing			= 0.10
}

DesignRule	{
		layer1				= "via5Blockage"
		layer2				= "VIA5"
		minSpacing			= 0.10
}

PRRule		{
		rowSpacingTopTop		= 0
		rowSpacingTopBot		= 1.03
		rowSpacingBotBot		= 0
		abuttableTopTop			= 1
		abuttableTopBot			= 0
		abuttableBotBot			= 1
}
